package clinical.test;

import java.io.IOException;
import java.sql.Connection;

import junit.framework.TestCase;
import clinical.web.ConnectionSupportMixin;
import clinical.web.common.UserInfo;
import clinical.web.exception.DBPoolServiceException;
import clinical.web.services.DBPoolService;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: MyTestCase.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class MyTestCase extends TestCase {
	protected ConnectionSupportMixin mixin;

	public MyTestCase(String testName, String propsFile) throws IOException {
		this(testName, propsFile, false);
	}

	public MyTestCase(String testName, String propsFile,
			boolean skipQueryProcessorCache) throws IOException {
		super(testName);
		mixin = new ConnectionSupportMixin(propsFile, skipQueryProcessorCache);
		
	}

	protected void setUp() throws Exception {
		mixin.startup();
	}

	protected void tearDown() throws Exception {
        mixin.shutdown();
        
	}

	public DBPoolService getDbPoolService() {
		return mixin.getDbPoolService();
	}

	public String getDbID() {
		return mixin.getDbID();
	}

	public String[] getDbIDs() {
		return mixin.getDbIDs();
	}

	public UserInfo getUi() {
		return mixin.getUi();
	}

	public Connection getConnection() throws DBPoolServiceException {
		return mixin.getDbPoolService().getConnection( mixin.getUi().getName());
	}
	
	public void releaseConnection(Connection con) throws DBPoolServiceException {
		mixin.getDbPoolService().releaseConnection( mixin.getUi().getName(), con);
	}
	
	public String getProperty(String propName) {
		return mixin.getProperty(propName);
	}
}
