package clinical.web;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.List;
import java.util.Map;

import clinical.server.vo.Analysis;
import clinical.server.vo.Analysiscomponent;
import clinical.server.vo.Deriveddata;
import clinical.server.vo.Executedtransform;
import clinical.server.vo.Transformation;
import clinical.server.vo.Transformeddata;
import clinical.server.vo.Transforminputdata;
import clinical.web.common.UserInfo;
import clinical.web.services.AnalysisInstanceDataResult;
import clinical.web.vo.AnalysisCompInfo;
import clinical.web.vo.AnalysisInfo;
import clinical.web.vo.ExecutedTransformInfo;
import clinical.web.vo.TransformationInfo;
import clinical.xml.xcede2.AnalysisT;

/**
 * @author I. Burak Ozyurt
 * @version $Id: IProvenanceService.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public interface IProvenanceService {

	public void deleteProvenanceForAnalysisInstance(UserInfo ui, AnalysisT at)
			throws Exception;
	public void deleteProvenanceForAnalysisInstance(Connection con,
			UserInfo ui, AnalysisT at) throws Exception;

	public List<Executedtransform> addProvenanceForAnalysisInstance(Connection con,
			UserInfo ui, AnalysisT at, String analysisShortName,
			String snapshotID) throws Exception;
	
	public List<Executedtransform> addProvenanceForAnalysisInstance(
			UserInfo ui, AnalysisT at, String analysisShortName,
			String snapshotID) throws Exception;

	public List<Executedtransform> addExecutedTransforms(UserInfo ui,
			List<ExecutedTransformInfo> etiList,
			List<ExecutedTransformInfo> flowList) throws Exception;

	public Map<BigDecimal, Map<Transformeddata, Deriveddata>> getOutputDerivedData(
			UserInfo ui, List<Integer> executedTransformIDList)
			throws Exception;

	public Map<BigDecimal, Map<Transforminputdata, Deriveddata>> getInputDerivedData(
			UserInfo ui, List<Integer> executedTransformIDList)
			throws Exception;

	public List<Analysiscomponent> findComponents(UserInfo ui, AnalysisInfo ai)
			throws Exception;

	public Analysis addAnalysisRec(UserInfo ui, AnalysisInfo ai)
			throws Exception;

	public List<Transformation> addTransformations(UserInfo ui,
			List<TransformationInfo> tiList) throws Exception;

	public Analysis addAnalysisRecWithComponents(UserInfo ui, AnalysisInfo ai,
			List<AnalysisCompInfo> flowList) throws Exception;

	public AnalysisInstanceDataResult getMatchingExecutedTransforms(
			UserInfo ui, String subjectID, Integer expID, Integer visitID,
			Integer segmentID) throws Exception;

	public void deleteMatchingExecutedTransforms(UserInfo ui, String subjectID,
			Integer expID, Integer visitID, Integer segmentID) throws Exception;

	public void deleteAnalysis(UserInfo ui, AnalysisInfo ai) throws Exception;

}