package clinical.web;

import java.util.HashMap;
import java.util.Map;

import clinical.web.common.ISecurityService;
import clinical.web.exception.BaseException;

/**
 * Holder of display option/authorization related state valid throughout the
 * user session.
 *
 * @author I. Burak Ozyurt
 * @version $Id: SessionStateCoordinator.java,v 1.5 2006/05/02 01:06:36 bozyurt
 *          Exp $
 */
public class SessionStateCoordinator {
	/**
	 * maps a menu item identifier to a true or false value. True means the menu
	 * item is enabled
	 */
	Map<String, Boolean> menuItemStateMap = new HashMap<String, Boolean>(11);
	/** number of the databases the system can access */
	protected int numDBs = -1;
	protected boolean scoreCountOverLimit = false;
	protected String currentDBID = null;
	protected static Boolean TRUE = new Boolean("true");
	protected static Boolean FALSE = new Boolean("false");

	public final static String AS_QUERY = "Query Assessments";

	public SessionStateCoordinator(String curDBID) throws BaseException {
		ISecurityService secService = ServiceFactory.getSecurityService();
		numDBs = secService.getAllDBIDs().length;
		System.out.println("************************* # of dbs:" + numDBs);
		this.currentDBID = curDBID;
	}

	public void setScoreCountOverLimit(int numScores) {
		scoreCountOverLimit = numScores > 15;
	}

	public boolean getScoreCountOverLimit() {
		return scoreCountOverLimit;
	}

	public String getCurrentDBID() {
		return this.currentDBID;
	}

	public void setMenuItemState(String menuItemName, boolean enabled) {
		// Boolean state = (Boolean) menuItemStateMap.get(menuItemName);
		menuItemStateMap.put(menuItemName, new Boolean(enabled));
	}

	public void updateNumDbs() {
		ISecurityService secService;
		try {
			secService = ServiceFactory.getSecurityService();
			numDBs = secService.getAllDBIDs().length;
		} catch (BaseException e) {
		}
	}

	public Boolean getAssessmentQueryMenuEnabledState() {
		Boolean value = menuItemStateMap.get(AS_QUERY);
		if (value == null) {
			return TRUE;
		}
		return value;
	}

	public boolean getHasMultipleDatabases() {
		return numDBs > 1;
	}

}