package clinical.web.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.cache.CacheUtils;
import clinical.utils.ValidationUtils;
import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.SessionStateCoordinator;
import clinical.web.common.ISecurityAdminService;
import clinical.web.common.security.DBConfig;
import clinical.web.exception.ValidationException;
import clinical.web.forms.DBConfigForm;
import clinical.web.forms.UserAndDBConfigForm;
import clinical.web.services.SecurityService;

/**
 * @author I. Burak Ozyurt
 * @version $Id: DBConfigAction.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class DBConfigAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(DBConfigAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.dconf.add", "addDBConf");
		return map;
	}

	public ActionForward addDBConf(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		try {
			getUserInfo(request);
			DBConfigForm dbcForm = (DBConfigForm) form;
			String dbType = dbcForm.getDbTypeSelector().getSelectedItem();
			String dbURL = dbcForm.getDbURL();
			String dbId = dbcForm.getDbId();
			String siteURL = dbcForm.getSiteURL();
			if (siteURL != null && siteURL.trim().length() == 0)
				siteURL = null;
			validateFields(dbType, dbURL, dbId, siteURL);

			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();
			SecurityService ss = (SecurityService) saService;
			String siteUniqueId = dbcForm.getSiteSelector()
					.getSelectedSiteUniqueId();
			DBConfig dbConf = ss.addUpdateDatabase(dbId, dbURL, dbType,
					siteUniqueId, siteURL);
			if (dbConf != null) {
				UserAndDBConfigForm udcForm = (UserAndDBConfigForm) request
						.getSession().getAttribute("udcForm");
				udcForm.getDbConfigSelector().addDBConfig(dbConf);
				udcForm.getDbConfigs().add(dbConf);

				String[] dbIdArr = ss.getAllDBIDs();
				List<String> newDbIDList = new ArrayList<String>(dbIdArr.length);
				for (String aDbId : dbIdArr) {
					newDbIDList.add(aDbId);
				}
				super.getServlet().getServletContext().setAttribute(
						Constants.DBID_LIST_KEY, newDbIDList);

				CacheUtils.addDBID2SiteIDRec(dbConf.getId(), siteUniqueId);
				// synchronize the session state coordinator also
				HttpSession session = request.getSession();
				SessionStateCoordinator ssc = (SessionStateCoordinator) session
						.getAttribute(Constants.SESSION_STATE_COORDINATOR_KEY);
				if (ssc != null) {
					ssc.updateNumDbs();
				}
			}
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("DBConfigAction", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	protected void validateFields(String dbType, String dbURL, String dbId,
			String siteURL) throws ValidationException {
		ValidationUtils.notEmpty("DB Type", dbType);
		ValidationUtils.notEmpty("DB URL", dbURL);
		ValidationUtils.notEmpty("DB ID", dbId);
		String dbTypeConfirm = ValidationUtils.validJDBCUrl("DB URL", dbURL);
		ValidationUtils.validDBId("DB ID", dbId);
		if (!dbTypeConfirm.equals(dbType)) {
			if (!dbTypeConfirm.startsWith(dbType)) {
				throw new ValidationException(
						"Database type specified does not match DB URL!");
			}
		}
		if (siteURL != null)
			ValidationUtils.validHTTPURL("Site URL", siteURL);
	}
}
