package clinical.web.actions;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.utils.GenUtils;
import clinical.web.download.ImageSeriesDataInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */

public class ImageSeriesViewHelper {
	 public static final String REL_VIEWER_IMAGES_PATH = "/viewer/";

	public static JSONObject prepImagePreviewComObject(String siteID,
			ImageSeriesDataInfo isdi, File[] jpegFiles) throws JSONException {
		JSONObject js = new JSONObject();
		if (isdi != null) {
			js.put("siteID", siteID);
			js.put("subjectID", isdi.getSubjectID());
			js.put("experiment", isdi.getExpName());
			js.put("visit", isdi.getVisitID());
			js.put("segment", isdi.getSegmentID());
		}
		JSONArray jsArr = new JSONArray();
		js.put("jpegs", jsArr);
		if (jpegFiles != null) {
			// sort jpeg files in slice order
			Arrays.sort(jpegFiles, new Comparator<File>() {
				public int compare(File o1, File o2) {
					String prefix1 = o1.getName();
					prefix1 = prefix1.replaceFirst("\\..+$", "");
					String prefix2 = o2.getName();
					prefix2 = prefix2.replaceFirst("\\..+$", "");
					int num1 = GenUtils.toInt(prefix1, -1);
					int num2 = GenUtils.toInt(prefix2, -1);
					return num1 - num2;
				}
			});
			for (File file : jpegFiles) {
				String baseName = file.getName();
				String parentDir = file.getParentFile().getName();
				StringBuilder sb = new StringBuilder();
				sb.append(REL_VIEWER_IMAGES_PATH).append(parentDir);
				sb.append('/').append(baseName);
				String imagePath = sb.toString();
				if (imagePath.startsWith("/"))
					imagePath = imagePath.replaceFirst("^\\/+", "../");
				jsArr.put(imagePath);
			}
		}
		return js;
	}
}
