package clinical.web.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.web.common.AssessmentMapping;
import clinical.web.common.UserInfo;
import clinical.web.common.query.Operator;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.exception.BaseException;
import clinical.web.helpers.SubCorticalVarInfo;
import clinical.web.services.DebugAssessmentService;
import clinical.web.services.DerivedDataService;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: MultiSiteQueryWorker.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class MultiSiteQueryWorker implements Runnable {

	public final static int NONE = 0;
	public final static int STARTED = 1;
	public final static int FINISHED = 2;
	public final static int ERROR = 3;
	public final static int ASSESSMENT_QUERY = 1;
	public final static int SUBCORTICAL_QUERY = 2;

	protected int status = NONE;
	protected String id;
	protected String query;
	protected int queryType;
	protected BaseException be;
	protected List<Object> argList = new ArrayList<Object>();
	protected Object result;
	protected Object lock = new Object();
	protected String dbID;
	private static Log log = LogFactory.getLog("MultiSiteQueryWorker");

	public MultiSiteQueryWorker(String id, int queryType, String dbID) {
		this.id = id;
		this.queryType = queryType;
		this.dbID = dbID;
	}

	public String getID() {
		return id;
	}

	public synchronized int getStatus() {
		return status;
	}

	private synchronized void setStatus(int value) {
		this.status = value;
	}

	public int getQueryType() {
		return queryType;
	}

	public Object getLock() {
		return lock;
	}

	public void addArgument(Object arg) {
		argList.add(arg);
	}

	public synchronized Object getResult() {
		return result;
	}

	public BaseException getException() {
		return be;
	}

	@SuppressWarnings("unchecked")
   public void run() {
		log.info("started worker " + id);
		setStatus(STARTED);

		DebugAssessmentService asService = null;
		DerivedDataService ddService = new DerivedDataService();
		try {
			asService = new DebugAssessmentService(this.dbID);
			switch (queryType) {
			case ASSESSMENT_QUERY:
				List<Integer> experimentIDs = (argList.size() == 7) ? (List<Integer>) argList
						.get(argList.size() - 1)
						: null;

				log.info(" experimentIDs = " + experimentIDs + " "
						+ argList.get(argList.size() - 1));

				result = asService.queryForScores((UserInfo) argList.get(0),
						(String) argList.get(1),/* dbID */
						(String) argList.get(2), /* firstDBID */
						(Map<Integer, List<AssessmentMapping>>) argList.get(3), /* siteAsMap */
						(Operator) argList.get(4),
						(List<AssessmentSelectionInfo>) argList.get(5), /* asiList */
						experimentIDs);

				break;

			case SUBCORTICAL_QUERY:
				log.info("doing subcortical " + id);
				result = ddService.getSubCorticalValuesForSubjects(
						(UserInfo) argList.get(0), (String) argList.get(1), /* dbID */
						(List<SubCorticalVarInfo>) argList.get(2), /* derivedDataList */
						(Operator) argList.get(3));

				break;
			default:
				break;
			}
			setStatus(FINISHED);
			synchronized (lock) {
				lock.notifyAll();
			}
		} catch (Exception x) {
			setStatus(ERROR);
			be = new BaseException(x);
		}
	}

}
