package clinical.web.actions;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jdom.Element;
import org.json.JSONObject;

import clinical.web.Constants;
import clinical.web.IAssessmentService;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.forms.AsQueryBuilderForm;
import clinical.web.forms.SaveQueryForm;
import clinical.web.helpers.QueryWizardHelper;
import clinical.web.vo.QueryInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SaveQueryAction.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class SaveQueryAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(3);
	private Log log = LogFactory.getLog(SaveQueryAction.class);

	protected Map<String, String> getKeyMethodMap() {

		map.put("button.save_query", "saveQuery");
		map.put("button.cancel", "cancel");
		return map;
	}

	public SaveQueryAction() {
	}

	public ActionForward saveQuery(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		IAssessmentService asService = null;
		log.debug("*** SaveQueryAction");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			SaveQueryForm sqForm = (SaveQueryForm) form;

			if (sqForm.getDescription().trim().length() == 0) {
				throw new Exception(
						"A description is required to save a user query!");
			}

			asService = ServiceFactory.getAssessmentService(dbID);

			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
					.getAttribute(Constants.ASQUERYFORM_KEY);

			if (queryForm.getQueryInfo() != null) {
				// JSON
				QueryInfo qi = queryForm.getQueryInfo();
				String expID = null;
				if (queryForm.getExpSelector() != null) {
					expID = String.valueOf(queryForm.getExpSelector()
							.getSelectedExpID());
				}
				// FIXME what about SCOPE?????
				JSONObject js = qi.queryToJSON(expID);
				QueryWizardHelper.saveJSONQueryToDB(js,
						sqForm.getDescription(), ui, asService);

			} else {
				Element queryElem = QueryWizardHelper
						.prepareQueryForPersistence(queryForm);

				QueryWizardHelper.persistQueryToDB(queryElem, sqForm
						.getDescription(), ui, asService);
			}
			// make the saved query available to use for this session
			QueryWizardHelper.prepareStoredQueryDescriptions(ui, asService, ui
					.getName(), queryForm);
			if (queryForm.getQueryInfo() != null)
				return mapping.findForward("query");
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward cancel(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			getUserInfo(request);
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}

	}

}