package clinical.web.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.Assessment;
import clinical.server.vo.Assessmentscorecode;
import clinical.web.Constants;
import clinical.web.IAssessmentService;
import clinical.web.ServiceFactory;
import clinical.web.SessionStateCoordinator;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.common.query.QueryPartInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.forms.AsQueryBuilderForm;
import clinical.web.forms.StoredQuerySelector;
import clinical.web.helpers.AssessmentSelectionInfoHelper;
import clinical.web.helpers.ExperimentSelector;
import clinical.web.helpers.QueryWizardHelper;
import clinical.web.helpers.StoredQueryDescription;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SelectAssessmentAction.java,v 1.14.2.1 2007/08/27 22:54:57
 *          bozyurt Exp $
 */

public class SelectAssessmentAction extends BaseLookupDispatchAction {
	protected Map<String, String> buttonMap = new HashMap<String, String>(3);
	private Log log = LogFactory.getLog(SelectAssessmentAction.class);

	protected Map<String, String> getKeyMethodMap() {
		buttonMap.put("action.show", "show");
		buttonMap.put("button.continue", "processAssessmentSelections");
		buttonMap.put("button.load_saved_query", "loadSavedQuery");
		return buttonMap;
	}

	public SelectAssessmentAction() {
	}

	public ActionForward show(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			IAssessmentService asService = ServiceFactory
					.getAssessmentService(dbID);
			List<Assessment> assessments = asService.getAllAssessments(ui);
			AsQueryBuilderForm queryForm = new AsQueryBuilderForm();
			session.setAttribute(Constants.ASQUERYFORM_KEY, queryForm);

			List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>(
					assessments.size());
			for (Assessment as : assessments) {
				AssessmentSelectionInfo asi = new AssessmentSelectionInfo();
				asi.setAssessmentID(as.getAssessmentid());
				asi.setDescription(as.getDescription());
				asi.setName(as.getName());
				asiList.add(asi);
			}

			Collections.sort(asiList,
					new Comparator<AssessmentSelectionInfo>() {
						public int compare(AssessmentSelectionInfo asi1,
								AssessmentSelectionInfo asi2) {
							return asi1.getName().compareToIgnoreCase(
									asi2.getName());
						}
					});

			queryForm.clean();

			for (Iterator<AssessmentSelectionInfo> iter = asiList.iterator(); iter
					.hasNext();) {
				AssessmentSelectionInfo asi = iter.next();
				queryForm.addAssessment(asi);
			}

			// prepare the stored query summaries for this user
			QueryWizardHelper.prepareStoredQueryDescriptions(ui, asService, ui
					.getPerceivedName(), queryForm);

			// set the session state coordinator to control menu items and/or
			// buttons based on the current state
			SessionStateCoordinator ssc = new SessionStateCoordinator(dbID);
			session.setAttribute(Constants.SESSION_STATE_COORDINATOR_KEY, ssc);

		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}

		return mapping.findForward(Constants.SHOW_QUERY_WIZARD);
	}

	public ActionForward processAssessmentSelections(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		// Locale locale = this.getLocale(request);
		log.debug("**** SelectAssessmentAction");
		// MessageResources messages = this.getResources(request);

		IAssessmentService asService = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			asService = ServiceFactory.getAssessmentService(dbID);
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
					.getAttribute(Constants.ASQUERYFORM_KEY);
			queryForm.setState(Constants.SEL_ASSESSMENT);

			String state = queryForm.getState();
			log.debug("state=" + state);

			QueryWizardHelper qwHelper = new QueryWizardHelper();
			qwHelper.validateSelectAssessments(queryForm, request);

			List<AssessmentSelectionInfo> asiList = queryForm.getAssessments();

			if (state.equals(Constants.SEL_ASSESSMENT)) {

				log.debug("traversing the list of assessments");
				qwHelper.populateScoresForSelectedAssessments(ui, asService,
						asiList, queryForm);

				int numScores = qwHelper.getNumberOfScores(queryForm);

				SessionStateCoordinator ssc = (SessionStateCoordinator) session
						.getAttribute(Constants.SESSION_STATE_COORDINATOR_KEY);
				ssc.setMenuItemState(SessionStateCoordinator.AS_QUERY, false);
				ssc.setScoreCountOverLimit(numScores);

				// for the next step
				queryForm.setState(Constants.SEL_SCORE);
			}
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}

		return mapping.findForward(Constants.SUCCESS);
	}

	public ActionForward loadSavedQuery(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		IAssessmentService asService = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			asService = ServiceFactory.getAssessmentService(dbID);

			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			StoredQuerySelector sqs = queryForm.getSavedQuerySelector();
			QueryWizardHelper qwHelper = new QueryWizardHelper();

			IDBCache dbCache = ServiceFactory.getDBCache(dbID);

			Map<String, List<Assessmentscorecode>> scoreCodeMap = dbCache
					.getScoreCodeMap(ui, false);
			AssessmentSelectionInfoHelper helper = new AssessmentSelectionInfoHelper(
					asService, ui, queryForm, scoreCodeMap);

			log.info("selected query ID=" + sqs.getSelectedQueryID());
			StoredQueryDescription sqd = QueryWizardHelper.loadQueryFromDB(ui,
					asService, sqs.getSelectedQueryID(), ui.getPerceivedName(),
					helper);
			for (Iterator<QueryPartInfo> iter = sqd.getQueryParts().iterator(); iter
					.hasNext();) {
				QueryPartInfo qpi = iter.next();
				log.info(qpi.toString());
			}

			qwHelper.prepareQueryWizardSelectionState(dbID, ui, queryForm,
					helper, sqd.getQueryParts());
			ExperimentSelector expSelector = queryForm.getExpSelector();
			if (expSelector == null) {
				QueryWizardHelper.prepareExperimentSelector(ui, queryForm,
						dbCache);
				expSelector = queryForm.getExpSelector();
			}
			expSelector.setSelectedExpID(sqd.getExpID());

			// indicate successful loading of the saved query
			queryForm.setSavedQueryLoaded(true);

			return mapping.findForward(Constants.LOAD_QUERY);

		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

}
