package clinical.web.common;

import java.util.Map;

import clinical.web.common.security.DBConfig;
import clinical.web.common.security.User;

/**
 * Interface for security services for internal usage allows access to
 * the passwords, to other databases than the current user's connected one
 * and corresponding users.
 *
 * @author I. Burak Ozyurt
 * @version $Id: ISecurityService.java 91 2009-08-17 23:38:26Z bozyurt $
 */

public interface ISecurityService {

  /**
   * returns username keyed dictionary of user information
   * @param dbID
   * @return a <code>Map</code>
   */
  public Map<String, User> getAllUsers(String dbID);

  /**
   * @param dbID
   * @return
   */
  public Map<String, User> getAllNamedUsers(String dbID);

  /**
   *
   * @return the database id for the default database the system will connect
   */
  public String getDefaultDBID();

  /**
   *
   * @return an array of database IDs used to get a connection from a the corresponding databases
   */
  public String[] getAllDBIDs();

  /**
   *
   * @param dbID
   * @return the database type for the database with id <code>dbID</code>
   */
  public String getDBType(String dbID);

  public User getRestrictedUser(String dbID);

  public DBConfig findBySiteID(String siteID);

  public String findSiteIDByDbID(String dbID);

  public String findDBForSiteID(String siteID);

  public  Map<String, String> getSiteURLs();

}