package clinical.web.common.vo;

import java.io.Serializable;
import java.util.List;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: Row.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class Row<E> implements Serializable {
	private static final long serialVersionUID = 1L;
	protected List<E> columns;
	protected int maxColCount;

	public Row(List<E> cols, int maxColCount) {
		this.columns = cols;
		this.maxColCount = maxColCount;
	}

	public void addColumn(E col) {
		columns.add(col);
	}

	public List<E> getColumns() {
		return columns;
	}

	public int getColCount() {
		if (columns == null)
			return 0;
		return columns.size();
	}

	public int getMaxColCount() {
		return maxColCount;
	}

	public int getColSpan() {
		if (maxColCount > columns.size())
			return maxColCount;
		return 1;
	}
}
