package clinical.web.download;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DataNode.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class DataNode implements Serializable {
	private static final long serialVersionUID = -7673655168423837943L;
	protected String title;
	protected String type;
	protected Object userObject;
	protected DataNode parent;
	protected List<DataNode> children;

	public DataNode(String title, Object userObject, String type,
			DataNode parent) {
		super();
		this.title = title;
		this.userObject = userObject;
		this.type = type;
		this.parent = parent;
	}

	public DataNode(String title, Object userObject, String type) {
		this(title, userObject, type, null);
	}

	public List<DataNode> getChildren() {
		return children;
	}

	public boolean hasChildren() {
		return !(children == null || children.isEmpty());
	}

	public void addChild(DataNode child) {
		child.parent = this;
		if (children == null) {
			children = new ArrayList<DataNode>(5);
		}
		children.add(child);
	}
	
	public void removeChild(DataNode child) {
		children.remove(child);
	}

	public DataNode getParent() {
		return parent;
	}

	public String getTitle() {
		return title;
	}

	public Object getUserObject() {
		return userObject;
	}

	public String getType() {
		return type;
	}

	public String buildFilePath() {
		if (!type.equals("file") && !type.equals("dir"))
			return null;
		Stack<DataNode> stack = new Stack<DataNode>();
		DataNode p = this;
		while (p != null
				&& (p.getType().equals("file") || p.getType().equals("dir"))) {
			stack.push(p);
			p = p.getParent();
		}
		StringBuffer buf = new StringBuffer();
		boolean first = true;
		while (!stack.isEmpty()) {
			if (!first)
				buf.append('/');
			p = stack.pop();
			buf.append(p.getTitle());
		}
		return buf.toString();
	}

}
