package clinical.web.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.apache.struts.action.ActionForm;

import clinical.web.helpers.MissingEntry;
import clinical.web.helpers.ScoreValuesDisplayLayout;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentEntriesForm.java,v 1.2 2006/05/02 01:03:18 bozyurt
 *          Exp $
 */
public class AssessmentEntriesForm extends ActionForm {
	private static final long serialVersionUID = 2245287925277344667L;
	protected ScoreValuesDisplayLayout firstEntrySVDL;
	protected ScoreValuesDisplayLayout secondEntrySVDL;
	protected List<ScoreValuesDisplayLayout> entryList = new ArrayList<ScoreValuesDisplayLayout>(
			2);
	protected String assessmentName;
	protected List<MissingEntry> missingEntries;

	public AssessmentEntriesForm() {
	}

	public void addScoreValuesDisplayLayout(ScoreValuesDisplayLayout svdl) {
		entryList.add(svdl);
	}

	public void setMissingEntries(List<MissingEntry> missingEntries) {
		this.missingEntries = missingEntries;
		Collections.sort(this.missingEntries, new Comparator<MissingEntry>() {
			public int compare(MissingEntry me1, MissingEntry me2) {
				int diff = me1.getEntryID() - me2.getEntryID();
				if (diff == 0) {
					return me1.getScoreSequence() - me2.getScoreSequence();
				}
				return diff;
			}
		});
	}

	public List<MissingEntry> getMissingEntries() {
		return missingEntries;
	}

	public List<ScoreValuesDisplayLayout> getEntryList() {
		return entryList;
	}

	public void setAssessmentName(String newAssessmentName) {
		this.assessmentName = newAssessmentName;
	}

	// ---------------------- getters --------------
	public ScoreValuesDisplayLayout getFirstEntrySVDL() {
		System.out.println(firstEntrySVDL.toString());
		return this.firstEntrySVDL;
	}

	public ScoreValuesDisplayLayout getSecondEntrySVDL() {
		return this.secondEntrySVDL;
	}

	public String getAssessmentName() {
		return this.assessmentName;
	}

}
