package clinical.web.forms;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.struts.action.ActionForm;

import clinical.web.common.vo.AssessmentSelectionInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: BatchQueryForm.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class BatchQueryForm extends ActionForm {
	private static final long serialVersionUID = -8838744278768027286L;
	protected List<AssessmentSelectionInfo> asiList;
	protected String queryReminder;
	protected Set<String> jobIDSet = new HashSet<String>();

	public BatchQueryForm() {
		super();
	}

	public void addJobID(String jobID) {
		jobIDSet.add(jobID);
	}

	public List<AssessmentSelectionInfo> getAsiList() {
		return asiList;
	}

	public void setAsiList(List<AssessmentSelectionInfo> asiList) {
		this.asiList = asiList;
	}

	/**
	 * indexed property
	 * 
	 * @param idx
	 * @return
	 */
	public AssessmentSelectionInfo getAsi(int idx) {
		if (idx > asiList.size())
			return null;
		return asiList.get(idx);
	}

	public String getQueryReminder() {
		return queryReminder;
	}

	public void setQueryReminder(String queryReminder) {
		this.queryReminder = queryReminder;
	}


	public Set<String> getJobIDSet() {
		return jobIDSet;
	}

}
