package clinical.web.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import clinical.web.common.vo.VisitSegmentScoreValues;

/**
 * Holds information for a score value to be displayed in the assessment query
 * results.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ScoreValueSummary.java,v 1.7.2.2 2007/07/03 01:43:59 bozyurt
 *          Exp $
 */

public class ScoreValueSummary {
	private String subjectID;
	private String assessmentID;
	private String experimentID;
	private String experimentName;
	private String siteID;
	private String timeStamp;
	private String subjectImageDownloadURL;
	private Map<String, String> paramMap = new HashMap<String, String>(3);
	private Map<String, VisitSegmentScoreValues> vssvMap = new LinkedHashMap<String, VisitSegmentScoreValues>(3);
	private List<ScoreValueIdxInfo> svIdxInfoList = new ArrayList<ScoreValueIdxInfo>(5);

	public ScoreValueSummary() {
	}

	public ScoreValueSummary(String siteID, String subjectID,
			String assessmentID, String timeStamp, String experimentID) {
		this.siteID = siteID;
		this.subjectID = subjectID;
		this.assessmentID = assessmentID;
		this.timeStamp = timeStamp;
		this.experimentID = experimentID;
	}

	// ---------------------- setters --------------
	public void setSubjectID(String newSubjectID) {
		this.subjectID = newSubjectID;
	}

	public void setAssessmentID(String newAssessmentID) {
		this.assessmentID = newAssessmentID;
	}

	public void setTimeStamp(String newTimeStamp) {
		this.timeStamp = newTimeStamp;
	}

	public void setSiteID(String newSiteID) {
		this.siteID = newSiteID;
	}

	public void setSubjectImageDownloadURL(String newSubjectImageDownloadURL) {
		this.subjectImageDownloadURL = newSubjectImageDownloadURL;
	}

	public void setSvIdxInfoList(List<ScoreValueIdxInfo> newSvIdxInfoList) {
		this.svIdxInfoList = newSvIdxInfoList;

		for (Iterator<VisitSegmentScoreValues> iter = vssvMap.values().iterator(); iter.hasNext();) {
			VisitSegmentScoreValues vssv = iter
					.next();
			vssv.setSvIdxInfoList(svIdxInfoList);
		}
	}

	public List<ScoreValueIdxInfo> getSvIdxInfoList() {
		return this.svIdxInfoList;
	}

	public String getParamJSON() {
		StringBuffer buf = new StringBuffer();
		buf.append("['subjectID=").append(subjectID).append("',");
		buf.append("'siteID=").append(siteID);
		buf.append("','expID=").append(experimentID).append("']");
		return buf.toString();
	}

	public Map<String, String> getParamMap() {
		if (paramMap.isEmpty()) {
			paramMap.put("sid", getSubjectID());
			paramMap.put("siteid", getSiteID());
		}
		return paramMap;
	}

	public String getAllSiteIDs() {
		StringBuilder buf = new StringBuilder();
		Set<String> uniqSiteIDs = new TreeSet<String>();
		for (Iterator<VisitSegmentScoreValues> iter = vssvMap.values().iterator(); iter.hasNext();) {
			VisitSegmentScoreValues vssv = iter
					.next();
			if (!uniqSiteIDs.contains(vssv.getSiteID())) {
				uniqSiteIDs.add(vssv.getSiteID());
			}
		}
		for (Iterator<String> iter = uniqSiteIDs.iterator(); iter.hasNext();) {
			String sid = iter.next();
			buf.append(sid);
			if (iter.hasNext()) {
				buf.append(',');
			}
		}
		return buf.toString();
	}

	public VisitSegmentScoreValues addVisitSegmentScoreValues(int visitID,
			int segmentID, int experimentID, String siteID, int valuesSize) {
		String key = getKey(visitID, segmentID, experimentID);
		VisitSegmentScoreValues vss = new VisitSegmentScoreValues(visitID,
				segmentID, experimentID, siteID, valuesSize);
		vssvMap.put(key, vss);
		return vss;
	}

	public VisitSegmentScoreValues getVisitSegmentScoreValues(int visitID,
			int segmentID, int experimentID) {
		String key = getKey(visitID, segmentID, experimentID);
		return vssvMap.get(key);
	}

	public String getKey(int visitID, int segmentID, int experimentID) {
		StringBuffer buf = new StringBuffer();
		buf.append(visitID).append('_').append(segmentID).append('_').append(
				experimentID);
		return buf.toString();
	}

	public Collection<VisitSegmentScoreValues> getVisitSegmentScoreValues() {
		return vssvMap.values();
	}

	public int getNumberOfColumns() {
		if (vssvMap.size() == 0)
			return 0;
		return vssvMap.values().iterator().next()
				.getValues().size();
	}

	// ---------------------- getters --------------
	public String getSubjectID() {
		return this.subjectID;
	}

	public String getAssessmentID() {
		return this.assessmentID;
	}

	public String getTimeStamp() {
		return this.timeStamp;
	}

	public String getSiteID() {
		return this.siteID;
	}

	public String getSubjectImageDownloadURL() {
		return this.subjectImageDownloadURL;
	}

	public String getExperimentID() {
		return experimentID;
	}

	public void setExperimentID(String experimentID) {
		this.experimentID = experimentID;
	}

	public String getExperimentName() {
		return experimentName;
	}

	public void setExperimentName(String experimentName) {
		this.experimentName = experimentName;
	}
	
	public String toString() {
		StringBuffer buf = new StringBuffer(224);
		buf.append("ScoreValueSummary::[");
		buf.append("subjectID=").append(subjectID);
		buf.append(", assessmentID=").append(assessmentID);
		buf.append(", siteID=").append(siteID);
		buf.append(", timeStamp=").append(timeStamp);
		buf.append(", subjectImageDownloadURL=")
				.append(subjectImageDownloadURL);
		for (Iterator<VisitSegmentScoreValues> iter = vssvMap.values().iterator(); iter.hasNext();) {
			VisitSegmentScoreValues vssv = iter
					.next();
			buf.append("\n\t").append(vssv.toString());
		}
		buf.append("\n]");
		return buf.toString();
	}

	public static class ScoreValueIdxInfo {
		int svIdx;
		int headLocIdx; // 0 based (sub)Header location idx to match svIdx

		public ScoreValueIdxInfo(int svIdx, int headLocIdx) {
			this.svIdx = svIdx;
			this.headLocIdx = headLocIdx;
		}

		public int getSvIdx() {
			return svIdx;
		}

		public int getHeadLocIdx() {
			return headLocIdx;
		}
	}

}
