package clinical.web.helpers.security;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import clinical.server.dao.DatabaseuserDAO;
import clinical.server.dao.PrivilegesDAO;
import clinical.server.dao.UserPrivilegesDAO;
import clinical.server.vo.Databaseuser;
import clinical.server.vo.Privileges;
import clinical.server.vo.UserPrivileges;
import clinical.web.DAOFactory;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBPoolService;
import clinical.web.exception.DBPoolServiceException;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AuthenticationHelper.java 91 2009-08-17 23:38:26Z bozyurt $
 */

public class AuthenticationHelper {
	private IDBPoolService pool = null;
	private String dbID;

	public AuthenticationHelper(String dbID) throws DBPoolServiceException {
		pool = ServiceFactory.getPoolService(dbID);
		this.dbID = dbID;
	}

	public Map<Integer, String> getPrivileges(String adminUser)
			throws Exception {
		Connection con = null;
		Map<Integer, String> privilegesMap = new HashMap<Integer, String>();
		try {
			con = pool.getConnection(adminUser);
			PrivilegesDAO dao = DAOFactory.createPrivilegesDAO(dbID);
			List<?> privileges = dao.find(con, new Privileges());
			for (Iterator<?> iter = privileges.iterator(); iter.hasNext();) {
				Privileges priv = (Privileges) iter.next();
				privilegesMap.put(new Integer(priv.getPrivid().intValue()),
						priv.getPrivilege());
			}
		} finally {
			pool.releaseConnection(adminUser, con);
		}
		return privilegesMap;
	}

	/**
	 * returns a map keyed by privilege strings for the user for O(1)
	 * authentication checking
	 * 
	 * @param user
	 * @param adminUser
	 * @param privilegesMap
	 */
	public Map<String, Integer> getUserPrivileges(String user,
			String adminUser, Map<Integer, String> privilegesMap)
			throws Exception {
		Connection con = null;
		Map<String, Integer> userPrivMap = new HashMap<String, Integer>();
		try {
			con = pool.getConnection(adminUser);
			Databaseuser criteria = new Databaseuser();
			criteria.setName(user);
			DatabaseuserDAO dbUserDao = DAOFactory.createDatabaseuserDAO(dbID);
			List<?> dbUsers = dbUserDao.find(con, criteria);
			if (dbUsers.isEmpty())
				throw new Exception("User " + user
						+ " is not recognized as a valid user!");
			Databaseuser theUser = (Databaseuser) dbUsers.get(0);
			UserPrivilegesDAO dao = DAOFactory.createUserPrivilegesDAO(dbID);
			UserPrivileges up = new UserPrivileges();

			up.setUserid(theUser.getUniqueid());
			List<?> user_privs = dao.find(con, up);
			for (Iterator<?> iter = user_privs.iterator(); iter.hasNext();) {
				UserPrivileges user_priv = (UserPrivileges) iter.next();
				Integer privId = new Integer(user_priv.getPrivid().intValue());
				String priviledgeStr = (String) privilegesMap.get(privId);
				if (priviledgeStr != null) {
					if (userPrivMap.get(priviledgeStr) != null)
						userPrivMap.put(priviledgeStr, privId);
				}
			}
		} finally {
			pool.releaseConnection(adminUser, con);
		}
		return userPrivMap;

	}
}