package clinical.web.services;

import java.math.BigDecimal;
import java.util.Map;

import clinical.web.common.UserInfo;
import clinical.web.vo.AssessmentScoreValues;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SubjectAsmContext.java 90 2009-08-17 23:37:45Z bozyurt $
 */
public class SubjectAsmContext {
	String dbID;
	UserInfo ui;
	AssessmentScoreValues asv;
	int raterID;
	BigDecimal entryID;
	BigDecimal keyerID;
	boolean validated;
	Map<String, Map<String, String>> dbVarMetaDataMap;
	BigDecimal missClassificationID;

	public SubjectAsmContext(String dbid, Map<String, Map<String, String>> map,
			BigDecimal entryid, UserInfo ui) {
		dbID = dbid;
		dbVarMetaDataMap = map;
		entryID = entryid;
		this.ui = ui;
	}

	public AssessmentScoreValues getAsv() {
		return asv;
	}

	public void setAsv(AssessmentScoreValues asv) {
		this.asv = asv;
	}

	public String getDbID() {
		return dbID;
	}

	public void setDbID(String dbID) {
		this.dbID = dbID;
	}

	public Map<String, Map<String, String>> getDbVarMetaDataMap() {
		return dbVarMetaDataMap;
	}

	public void setDbVarMetaDataMap(
			Map<String, Map<String, String>> dbVarMetaDataMap) {
		this.dbVarMetaDataMap = dbVarMetaDataMap;
	}

	public BigDecimal getEntryID() {
		return entryID;
	}

	public void setEntryID(BigDecimal entryID) {
		this.entryID = entryID;
	}

	public BigDecimal getKeyerID() {
		return keyerID;
	}

	public void setKeyerID(BigDecimal keyerID) {
		this.keyerID = keyerID;
	}

	public BigDecimal getMissClassificationID() {
		return missClassificationID;
	}

	public void setMissClassificationID(BigDecimal missClassificationID) {
		this.missClassificationID = missClassificationID;
	}

	public int getRaterID() {
		return raterID;
	}

	public void setRaterID(int raterID) {
		this.raterID = raterID;
	}

	public UserInfo getUi() {
		return ui;
	}

	public void setUi(UserInfo ui) {
		this.ui = ui;
	}

	public boolean isValidated() {
		return validated;
	}

	public void setValidated(boolean validated) {
		this.validated = validated;
	}

}
