package clinical.web.vo;

/**
 * @author I. Burak Ozyurt
 * @version $Id: MachineInfo.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class MachineInfo {
	protected String architecture;
	protected String opSystem;
	protected String osVersion;
	/** ip address or hostname */
	protected String address;
	protected String description;

	public String getArchitecture() {
		return architecture;
	}

	public String getOpSystem() {
		return opSystem;
	}

	public String getOsVersion() {
		return osVersion;
	}

	public String getAddress() {
		return address;
	}

	public void setArchitecture(String architecture) {
		this.architecture = architecture;
	}

	public void setOpSystem(String opSystem) {
		this.opSystem = opSystem;
	}

	public void setOsVersion(String osVersion) {
		this.osVersion = osVersion;
	}

	public void setAddress(String address) {
		this.address = address;
	}
	
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("MachineInfo::[");
		buf.append("architecture");
		buf.append(']');
		return buf.toString();
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((address == null) ? 0 : address.hashCode());
		result = prime * result
				+ ((architecture == null) ? 0 : architecture.hashCode());
		result = prime * result
				+ ((opSystem == null) ? 0 : opSystem.hashCode());
		result = prime * result
				+ ((osVersion == null) ? 0 : osVersion.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final MachineInfo other = (MachineInfo) obj;
		if (address == null) {
			if (other.address != null)
				return false;
		} else if (!address.equals(other.address))
			return false;
		if (architecture == null) {
			if (other.architecture != null)
				return false;
		} else if (!architecture.equals(other.architecture))
			return false;
		if (opSystem == null) {
			if (other.opSystem != null)
				return false;
		} else if (!opSystem.equals(other.opSystem))
			return false;
		if (osVersion == null) {
			if (other.osVersion != null)
				return false;
		} else if (!osVersion.equals(other.osVersion))
			return false;
		return true;
	}
}
