package clinical.web.vo;

/**
 * @author I. Burak Ozyurt
 * @version $Id: TransformArgInfo.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class TransformArgInfo {
	protected String argName;
	protected boolean optional;
	protected boolean isInputData;
	protected boolean isOutputData;
	protected ArgumentTypeInfo argType;
	protected String argDataType;
	protected TransformationInfo transform;

	public final static String INT = "integer";
	public final static String STRING = "varchar";
	public final static String FLOAT = "float";
	public final static String BOOL = "boolean";

	public String getArgName() {
		return argName;
	}

	public boolean isOptional() {
		return optional;
	}

	public boolean isInputData() {
		return isInputData;
	}

	public boolean isOutputData() {
		return isOutputData;
	}

	public ArgumentTypeInfo getArgType() {
		return argType;
	}

	public String getArgDataType() {
		return argDataType;
	}

	public void setArgName(String argName) {
		this.argName = argName;
	}

	public void setOptional(boolean optional) {
		this.optional = optional;
	}

	public void setInputData(boolean isInputData) {
		this.isInputData = isInputData;
	}

	public void setOutputData(boolean isOutputData) {
		this.isOutputData = isOutputData;
	}

	public void setArgType(ArgumentTypeInfo argType) {
		this.argType = argType;
	}

	public void setArgDataType(String argDataType) {
		this.argDataType = argDataType;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((argName == null) ? 0 : argName.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final TransformArgInfo other = (TransformArgInfo) obj;
		if (argName == null) {
			if (other.argName != null)
				return false;
		} else if (!argName.equals(other.argName))
			return false;
		return true;
	}

	public TransformationInfo getTransform() {
		return transform;
	}

	public void setTransform(TransformationInfo transform) {
		this.transform = transform;
	}

	
}
