<%@ page contentType="text/html;charset=UTF-8" language="java" %>

<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>

<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<script type="text/javascript">
function go(elem,actionValue) {
   elem.form.action.value = actionValue;
   elem.form.submit();
   return false;
}

</script>
<div class="error">
  <html:errors/>
</div>
<form method="post" action="<c:url value="/batchdownload.do"/>">
<input type="hidden" name="action" value=""></input>
<input type="hidden" name="selExpID" value=""></input>
<table border="0" cellspacing="0" bgcolor="#d3d3d3" class="tablelist" >
   <tr bgcolor="#00659c">
      <td  align="center">
         <span style="color:white; font-weight:bold; font-size:12pt;">Download Image Sets by RunType </span>
      </td>
   </tr>
   <tr height="35px" >
     <td>
       <span style="font-weight:bold" >Bundle Name:</span>
       <html:text name="scForm" property="bundleName" /><span style="color:red;font-size:10pt; vertical-align:bottom;"> *</span>
     </td>
   </tr>
   <c:if test="$scForm.supportEmail}">
      <tr>
        <td>
          <div style="border:1px dotted #2f4f4f; padding:0.5em; padding-right:1em;">
           <div style="padding-top:2px; padding-bottom:2px;">
            <html:checkbox name="scForm" property="notifyByEmail">Email Notification</html:checkbox>
           </div>
           <div style="padding-top:2px; padding-bottom:2px;">  
            <span style="font-weight:bold" >Notification email:</span>&nbsp;<html:text name="scForm" property="email" />
           </div> 
         </div>
           
	</td>
      </tr>
   </c:if>
   <c:if test="${empty scForm.expNames}">
      <tr><td>
      <span style="color:red; font-weight: bold;">No Image Data is available!</span>
      </td></tr>
   </c:if>
   <c:if test="${not empty scForm.expNames}">
   <c:forEach var="expName" items="${scForm.expNames}">
   <c:if test="${not empty scForm.esidbMap[expName]}">
     <c:set var="esidb" value="${scForm.esidbMap[expName]}" />
     <tr>
       <td><span style="color:maroon; font-weight: bold;"><c:out value="${expName}" /></span>
        ( Max <c:out value="${esidb.subjectCount}"/> subject(s) )</td>
     </tr>
     <c:forEach var="runType" items="${esidb.runTypes}">
       <tr>
        <td>
          &nbsp; 
	  <input type="checkbox" name='<c:out value="${esidb.key}_runType"/>' value="<c:out value="${runType}"/>" >
	  <c:out value="${runType}"/></input>
        </td>
       </tr>
     </c:forEach>
   </c:if>  
   </c:forEach>
   </c:if>
   <tr>
     <td align="right">
       <input type="submit" class="submit-button" value="Cancel" onclick="return go(this,'Cancel')"></input> &nbsp;
       <c:if test="${not empty scForm.expNames}">
         <input type="submit" class="submit-button" value="Schedule Download" onclick="return go(this,'BatchDownload')"></input>
       </c:if>
       &nbsp;
     </td>
   </tr>
</table>
</form>
