#!/bin/bash

darwin=false
cygwin=false

case "`uname`" in
CYGWIN*) cygwin=true;;
Darwin*) darwin=true;;
esac

SEP=":"
if $cygwin; then
   SEP=";"
fi

ROOT_DIR=/data/dev/java/cbf_birn/hid/codegen/trunk/codegen
if [ "$BUILD_DIR" == "" ]
then
  if $cygwin; then
     BUILD_DIR=`cygpath -m "$ROOT_DIR/build/classes"`

  else
     BUILD_DIR="$ROOT_DIR/build/classes"
  fi
fi

if [ ! -d "$BUILD_DIR" ]
then
  echo ""
  echo "Cannot continue"
  echo "Please set the environment var BUILD_DIR to a valid directory:$BUILD_DIR"
  exit 1;
fi
if [ "$CODEGEN_HOME" == "" ]
then
  if $cygwin; then
     CODEGEN_HOME=`cygpath -m "$ROOT_DIR"`
   else
     CODEGEN_HOME="$ROOT_DIR"
   fi
fi
if [ ! -d "$CODEGEN_HOME" ]
then
  echo ""
  echo "Cannot continue"
  echo "Please set the environment var CODEGEN_HOME to a valid directory:$CODEGEN_HOME"
  exit 1;
fi


unset CLASSPATH

for lib in "$CODEGEN_HOME"/lib/*.jar
do
  if [ "$CLASSPATH" == "" ]
  then
    CLASSPATH=$lib
  else
    CLASSPATH="${CLASSPATH}${SEP}$lib"
  fi
done
CLASSPATH="$CLASSPATH${SEP}$BUILD_DIR"
CLASSPATH="$CLASSPATH${SEP}$CODEGEN_HOME/conf${SEP}."
#echo $CLASSPATH

java -Xms200M -Xmx500M -cp "$CLASSPATH" edu.ucsd.fmri.codegen.CodeGenCLI $* 
