package edu.ucsd.fmri.codegen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author: I. Burak Ozyurt
 * @version: $Id: BeanGenHelper.java,v 1.8 2007/12/11 02:14:21 bozyurt Exp $
 */

public class BeanGenHelper {
	protected String beanName;
	protected String packageName;
	protected Map<String, String> properties;
	protected List<String> propList;

	public BeanGenHelper(String beanName, String packageName) {
		properties = new HashMap<String, String>();
		propList = new ArrayList<String>();
		this.beanName = beanName;
		this.packageName = packageName;
	}

	public void addProperty(String property, String type) {
		properties.put(property, type);
		propList.add(property); // to preserve order
	}

	public String getType(String property) {
		return properties.get(property);
	}

	public List<String> getProperties() {
		return propList;
	}

	public String getBeanName() {
		return beanName;
	}

	public String getPackageName() {
		return packageName;
	}

	public String getGetMethodName(String property) {
		return "get" + capitalizeFirstLetter(property);
	}

	public String getSetMethodName(String property) {
		return "set" + capitalizeFirstLetter(property);
	}

	public String getSQLType(String javaType) {
		return null;
	}

	public static String capitalizeFirstLetter(String str) {
		StringBuffer buf = new StringBuffer();
		buf.append(Character.toUpperCase(str.charAt(0)));
		buf.append(str.substring(1));
		return buf.toString();
	}
}