package edu.ucsd.fmri.codegen;

import edu.ucsd.fmri.dbutils.DBTable;
import edu.ucsd.fmri.dbutils.SchemaExtractor;
import guilib.common.FileNameValueField;
import guilib.common.NameComboField;
import guilib.common.NameValueField;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;

/**
 * @author I. Burak Ozyurt
 * @version $Id: CodeGenPane.java,v 1.8 2008/10/15 21:42:37 bozyurt Exp $
 */

public class CodeGenPane extends JPanel implements ActionListener,
		PropertyChangeListener {
	private static final long serialVersionUID = 4603396385752638459L;
	TitledBorder titledBorder;
	GridBagConstraints gc;
	JComboBox codeTypeCombo;
	JPanel labelPanel;
	JPanel fieldPanel;
	GridBagLayout gridBag = new GridBagLayout();
	JTextArea logArea = new JTextArea(6, 60);
	JList schemaObjList;
	JButton button = new JButton("Generate");
	JButton selectAllButton = new JButton("Select All");
	NameValueField packageNameField, excPackNameField, voPackageNameField,
			utilsPackageNameField;
	NameValueField interfacePackageNameField;
	FileNameValueField outputDirField;
	NameComboField codeTypeField;
	DefaultListModel listModel;
	ConfigurationInfo confInfo;
	JLabel excPackLabel, voPackLabel, utilsPackLabel, interfacePackLabel;

	SchemaExtractor schemaExtractor;

	// static final long serialVersionUID = -6L;

	public CodeGenPane(ConfigurationInfo confInfo) {
		this.confInfo = confInfo;
		init();

	}

	public void disableButtons() {
		button.setEnabled(false);
		selectAllButton.setEnabled(false);
	}

	public void enableButtons() {
		button.setEnabled(true);
		selectAllButton.setEnabled(true);
	}

	private void init() {
		titledBorder = new TitledBorder("Code Generation");
		logArea.setEditable(false);
		this.setBorder(titledBorder);
		this.setLayout(new BorderLayout());
		gc = new GridBagConstraints();

		JPanel logPanel = new JPanel(new BorderLayout());
		logPanel.setBorder(new TitledBorder("Log"));
		logPanel.add(new JScrollPane(logArea));
		this.add(logPanel, BorderLayout.SOUTH);
		JPanel paramsPanel = new JPanel(gridBag);
		paramsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		gc.weightx = 0.5;
		gc.anchor = GridBagConstraints.WEST;
		gc.gridx = 0;
		gc.gridy = 0;

		button.addActionListener(this);

		selectAllButton.addActionListener(this);

		schemaObjList = new JList(listModel = new DefaultListModel());
		schemaObjList.setVisibleRowCount(10);
		schemaObjList
				.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		JScrollPane scrollList = new JScrollPane(schemaObjList);
		scrollList.setPreferredSize(new Dimension(200, 150));

		JPanel genPanel = new JPanel();
		genPanel.setLayout(new BoxLayout(genPanel, BoxLayout.X_AXIS));
		genPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		JPanel panel1 = new JPanel();
		panel1.setLayout(new BoxLayout(panel1, BoxLayout.Y_AXIS));
		panel1.add(new JLabel("Selected schema elements for code generation:"));
		panel1.add(scrollList);
		genPanel.add(panel1);
		genPanel.add(Box.createHorizontalStrut(5));
		JPanel panel2 = new JPanel();
		panel2.setLayout(new BoxLayout(panel2, BoxLayout.Y_AXIS));
		panel2.add(button);
		genPanel.add(Box.createVerticalStrut(5));
		panel2.add(selectAllButton);
		genPanel.add(panel2);
		disableButtons();

		gridBag.setConstraints(genPanel, gc);

		paramsPanel.add(genPanel);

		labelPanel = new JPanel(new GridLayout(7, 1, 5, 5));
		labelPanel.add(new JLabel("Code Type:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Output Directory:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Package Name:", JLabel.RIGHT));

		labelPanel.add(interfacePackLabel = new JLabel(
				"DAO Interface Package Name:", JLabel.RIGHT));
		labelPanel.add(voPackLabel = new JLabel("Value Object Package Name:",
				JLabel.RIGHT));
		labelPanel.add(excPackLabel = new JLabel("Exception Package Name:",
				JLabel.RIGHT));
		labelPanel.add(utilsPackLabel = new JLabel("Utilities Package Name:",
				JLabel.RIGHT));

		fieldPanel = new JPanel(new GridLayout(7, 1, 5, 5));

		packageNameField = new NameValueField(null, 25);
		excPackNameField = new NameValueField(null, 25);
		voPackageNameField = new NameValueField(null, 25);
		utilsPackageNameField = new NameValueField(null, 25);
		interfacePackageNameField = new NameValueField(null, 25);

		if (confInfo.getDBType().equals("oracle")) {
			packageNameField.setValue(confInfo.getPackage("dao_oracle"));
		} else {
			packageNameField.setValue(confInfo.getPackage("dao_postgres"));
		}
		excPackNameField.setValue(confInfo.getPackage("exception"));
		voPackageNameField.setValue(confInfo.getPackage("vo"));
		utilsPackageNameField.setValue(confInfo.getPackage("utils"));
		interfacePackageNameField.setValue(confInfo.getPackage("interface"));

		fieldPanel.add(codeTypeField = new NameComboField(null, new String[] {
				"dao", "vo", "pk" }));
		fieldPanel.add(outputDirField = new FileNameValueField(null, 25, true));
		fieldPanel.add(packageNameField);
		outputDirField.setValue(confInfo.getOutRootDir());

		fieldPanel.add(interfacePackageNameField);
		fieldPanel.add(voPackageNameField);
		fieldPanel.add(excPackNameField);
		fieldPanel.add(utilsPackageNameField);

		codeTypeCombo = codeTypeField.getComboBox();
		codeTypeCombo.addActionListener(this);

		JPanel fieldGroupPanel = new JPanel(new BorderLayout(3, 3));
		fieldGroupPanel.add(labelPanel, BorderLayout.WEST);
		fieldGroupPanel.add(fieldPanel);

		gc.gridy = 1;
		gc.gridx = 0;
		gc.gridwidth = 2;
		gridBag.setConstraints(fieldGroupPanel, gc);
		paramsPanel.add(fieldGroupPanel);

		this.add(paramsPanel);
	}

	public void populateSchemaObjectList(SchemaExtractor se) {
		schemaExtractor = se;
		listModel.clear();
		List<String> schemaObjNames = new ArrayList<String>(60);
		for (Iterator<DBTable> iter = schemaExtractor.getTables(); iter.hasNext();) {
			DBTable table = iter.next();
			schemaObjNames.add(table.getName());
		}
		Collections.sort(schemaObjNames);
		int i = 0;
		for (Iterator<String> iter = schemaObjNames.iterator(); iter.hasNext();) {
			String tableName = iter.next();
			listModel.add(i, tableName);
			++i;
		}

	}

	private boolean isChanged(String newValue, String oldValue) {
		if (newValue == null || newValue.trim().length() == 0)
			return false;
		return !newValue.equals(oldValue);
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == button) {
			int minIndex = schemaObjList.getMinSelectionIndex();
			int maxIndex = schemaObjList.getMaxSelectionIndex();
			List<String> selTables = new LinkedList<String>();
			for (int i = minIndex; i <= maxIndex; i++) {
				if (schemaObjList.isSelectedIndex(i)) {
					selTables.add((String) listModel.get(i));
				}
			}
			if (selTables.isEmpty()) {
				JOptionPane.showMessageDialog(this,
						"At least one schema object must be selected!",
						"No selection", JOptionPane.ERROR_MESSAGE);
			} else {
				try {
					generateCode(selTables);

				} catch (Throwable t) {
					t.printStackTrace();
					JOptionPane.showMessageDialog(this, t.getMessage(),
							"Code Generation Error", JOptionPane.ERROR_MESSAGE);
				}
			}
		} else if (e.getSource() == selectAllButton) {
			System.out.println("selecting all");
			schemaObjList.setSelectionInterval(0, listModel.size() - 1);
			schemaObjList.repaint();
		} else if (e.getSource() == codeTypeCombo) {
			String codeType = (String) codeTypeCombo.getSelectedItem();
			packageNameField.setValue(confInfo.getPackage(codeType));
			if (codeType.equals("vo") || codeType.equals("pk")) {
				if (fieldPanel.getComponentCount() == 7) {
					fieldPanel.remove(3);
					fieldPanel.remove(3);
					fieldPanel.remove(3);
					fieldPanel.remove(3);
					labelPanel.remove(3);
					labelPanel.remove(3);
					labelPanel.remove(3);
					labelPanel.remove(3);
					repaint();

				}
			} else if (codeType.equals("dao")) {
				if (fieldPanel.getComponentCount() == 3) {
					fieldPanel.add(interfacePackageNameField, 3);
					fieldPanel.add(voPackageNameField, 4);
					fieldPanel.add(excPackNameField, 5);
					fieldPanel.add(utilsPackageNameField, 6);
					labelPanel.add(interfacePackLabel, 3);
					labelPanel.add(voPackLabel, 4);
					labelPanel.add(excPackLabel, 5);
					labelPanel.add(utilsPackLabel, 6);
					repaint();
				}
			}
		}
	}

	protected void generateCode(List<String> selTables) throws Exception {
		String[] tableList = new String[selTables.size()];

		selTables.toArray(tableList);
		if (outputDirField.getValue() != null
				&& outputDirField.getValue().length() > 0) {
			confInfo.setOutRootDir(outputDirField.getValue());
		}
		updateConfInfo();

		BeanGenerator.generate(confInfo.getDbType(), schemaExtractor, confInfo,
				codeTypeField.getValue(), tableList, this);
	}

   public void updateConfInfo() {
      String codeType = (String) codeTypeCombo.getSelectedItem();
		if (isChanged(packageNameField.getValue(), confInfo
				.getPackage(codeType)))
			confInfo.setPackage(codeType, packageNameField.getValue());

		if (codeType.equals("dao")) {
			if (isChanged(voPackageNameField.getValue(), confInfo
					.getPackage("vo")))
				confInfo.setPackage("vo", voPackageNameField.getValue());

			if (isChanged(excPackNameField.getValue(), confInfo
					.getPackage("exception")))
				confInfo.setPackage("exception", excPackNameField.getValue());

			if (isChanged(utilsPackageNameField.getValue(), confInfo
					.getPackage("utils")))
				confInfo.setPackage("utils", utilsPackageNameField.getValue());
		}
   }

	public void propertyChange(PropertyChangeEvent e) {
		if (e.getPropertyName().equals("message")) {
			String val = (String) e.getNewValue();

			if (val != null) {
				String eol = System.getProperty("line.separator");
				logArea.append(val + eol);
			}
		}
	}
}