package edu.ucsd.fmri.codegen;

import edu.ucsd.fmri.dbutils.DBTable;
import edu.ucsd.fmri.dbutils.SchemaExtractor;
import guilib.AppFrame;
import guilib.common.BaseDialog;
import guilib.common.GenUtils;
import guilib.common.NameComboField;
import guilib.propertyeditor.PropertyEditorPane;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;

import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

/**
 * @author I. Burak Ozyurt
 * @version $Id: CodeGeneratorGUI.java,v 1.8 2008/10/15 21:42:37 bozyurt Exp $
 */
public class CodeGeneratorGUI extends AppFrame {
	private static final long serialVersionUID = 3217787352161031680L;
	PropertyEditorPane pePane;
	NameComboField beanType;
	ParamsDialog paramsDlg;
	JSplitPane splitPane;
	JTree schemaTree;
	DefaultMutableTreeNode root;
	HelpDialog helpDlg;
	CodeGenPane cgPane;
	BeanGenerator beanGenerator;
	SchemaExtractor schemaExtractor;

	ConfigurationInfo ci = new ConfigurationInfo();

	public CodeGeneratorGUI(int width, int height) throws Exception {
		super(width, height);
		setTitle("Simple O/R Map Code Generator");
		// propertiesFile = "codegen.properties";
		init();
		setIconImage(createImageIcon("/images/code_gen_app.gif").getImage());
	}

	public static ImageIcon createImageIcon(String path) {
		java.net.URL imageURL = CodeGeneratorGUI.class.getResource(path);
		if (imageURL != null) {
			return new ImageIcon(imageURL);
		} else {
			System.err.println("Can not find image:" + path);
			return null;
		}
	}

	protected void init() throws Exception {

		String stateFile = System.getProperty("user.home") + File.separator
				+ ".codegenerator_state.ser";
		if (new File(stateFile).exists()) {
			try {
				ci = (ConfigurationInfo) GenUtils.deserialize(stateFile);
			} catch (Exception x) {
				ci = new ConfigurationInfo();
			}
		}

		root = new DefaultMutableTreeNode("<Database Schema>");
		root.add(new DefaultMutableTreeNode("Tables & Views"));

		JScrollPane schemaPane = new JScrollPane(schemaTree = new JTree(root));
		cgPane = new CodeGenPane(ci);
		JScrollPane paramsPane = new JScrollPane(cgPane);
		paramsPane.setPreferredSize(new Dimension(400, 400));

		schemaTree.setCellRenderer(new SchemaNodeRenderer());

		splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, schemaPane,
				paramsPane);
		splitPane.setOneTouchExpandable(true);
		splitPane.setDividerLocation(220);
		getContentPane().add(splitPane);
	}

	protected JMenu createFileMenu() {
		fileMenu = new JMenu("File");
		fileMenu.setMnemonic(KeyEvent.VK_F);

		JMenuItem item = new JMenuItem("Load Schema Objects", KeyEvent.VK_L);
		fileMenu.add(item);
		item.addActionListener(new OpenAdapter());

		fileMenu.addSeparator();
		item = new JMenuItem("Quit", KeyEvent.VK_Q);
		fileMenu.add(item);
		item.addActionListener(new CloseAdapter());

		return fileMenu;
	}

	protected JMenu createHelpMenu() {
		helpMenu = super.createHelpMenu();

		helpMenu.setMnemonic(KeyEvent.VK_H);

		JMenuItem item = new JMenuItem("Help Contents", KeyEvent.VK_C);
		helpMenu.add(item);
		item.addActionListener(new HelpAdapter());

		return helpMenu;
	}

	public void onOpen() {
		if (paramsDlg == null)
			paramsDlg = new ParamsDialog(this, "Codegen Parameters", ci);

		int rc = paramsDlg.showDialog();
		if (rc == BaseDialog.OK_PRESSED) {
			ci = paramsDlg.getConfInfo();

			ProgressDialog pdlg = new ProgressDialog(this,
					"Schema Extraction Progress", ci);

			if (pdlg.showDialog() == BaseDialog.OK_PRESSED) {
				schemaExtractor = pdlg.getSchemaExtractor();
				populateSchemaTree(schemaExtractor);
				cgPane.populateSchemaObjectList(schemaExtractor);
				cgPane.enableButtons();
			}
		}
	}

	public void onClose() {
		if (schemaExtractor != null) {
			System.out.println("closing database connection");
			schemaExtractor.shutdown();
		}
		if (ci != null) {
			cgPane.updateConfInfo();
			String stateFile = System.getProperty("user.home") + File.separator
					+ ".codegenerator_state.ser";
			try {
				GenUtils.serialize(ci, stateFile);
			} catch (Exception x) {
				x.printStackTrace();
			}
		}
		super.onClose();
	}

	public void onHelp() {
		if (helpDlg == null) {
			helpDlg = new HelpDialog(this, "Help");
		}
		System.out.println("showing help");
		helpDlg.showDialog();
	}

	void populateSchemaTree(SchemaExtractor se) {
		root.setUserObject(ci.getDbSchema());
		DefaultMutableTreeNode tableNode = (DefaultMutableTreeNode) root
				.getChildAt(0);
		Iterator<DBTable> it = se.getTables();
		while (it.hasNext()) {
			DBTable table = it.next();
			tableNode.add(new DefaultMutableTreeNode(table.getName()));
		}
		schemaTree.repaint();
	}

	public static class SchemaNodeRenderer extends DefaultTreeCellRenderer {
		private static final long serialVersionUID = -5114927685934886830L;
		ImageIcon leafIcon;
		ImageIcon parentIcon;

		public SchemaNodeRenderer() {
			leafIcon = CodeGeneratorGUI
					.createImageIcon("/images/schema_object.gif");
			parentIcon = CodeGeneratorGUI
					.createImageIcon("/images/parent_node.gif");
		}

		public Component getTreeCellRendererComponent(JTree tree, Object value,
				boolean sel, boolean expanded, boolean leaf, int row,
				boolean hasFocus) {
			super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf,
					row, hasFocus);
			if (leaf) {
				setIcon(leafIcon);
			} else {
				setIcon(parentIcon);
			}
			return this;
		}
	}

	class HelpAdapter implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			CodeGeneratorGUI.this.onHelp();
		}
	}

	class OpenAdapter implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			onOpen();
		}
	}

	class CloseAdapter implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			onClose();
		}
	}

	public static void setUIFont(FontUIResource fur) {
		Enumeration<?> keys = UIManager.getDefaults().keys();
		while (keys.hasMoreElements()) {
			Object key = keys.nextElement();
			Object value = UIManager.get(key);
			if (value instanceof FontUIResource) {
				UIManager.put(key, fur);
			}
		}
	}

	public static void main(String[] args) {
		CodeGeneratorGUI cg = null;
		try {
			setUIFont(new FontUIResource("Dialog", Font.PLAIN, 11));
			cg = new CodeGeneratorGUI(920, 610);
			cg.startup();
		} catch (Exception x) {
			x.printStackTrace();
		}
	}
}