package edu.ucsd.fmri.codegen;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: ConfigurationInfo.java,v 1.8 2008/10/15 21:42:37 bozyurt Exp $
 */
public class ConfigurationInfo implements java.io.Serializable {
	private static final long serialVersionUID = 1306229430469596174L;
	protected String dbType = "oracle";
	protected String loaderPath;
	protected String driverName = "oracle.jdbc.driver.OracleDriver";
	protected String outRootDir;
	protected String dbSchema;
	protected String dbURL;
	protected String user;
	transient String pwd;
	protected Map<String, String> packageMap = new HashMap<String, String>(7);
	static Map<String, String> dbTypeDriverMap = new HashMap<String, String>(7);

	static {
		dbTypeDriverMap.put("oracle", "oracle.jdbc.driver.OracleDriver");
		dbTypeDriverMap.put("postgres", "org.postgresql.Driver");
	}

	public ConfigurationInfo() {
		initialize();
	}

	protected void initialize() {
		packageMap.put("exception", "clinical.web.exception");
		packageMap.put("vo", "clinical.server.vo");
		packageMap.put("dao_oracle", "clinical.server.dao.oracle");
		packageMap.put("dao_postgres", "clinical.server.dao.postgres");

		packageMap.put("utils", "clinical.server.utils");
		packageMap.put("pk", "clinical.server.ejb");
		packageMap.put("interface", "clinical.server.dao");
	}

	public void setPackage(String key, String packageStr) {
		packageMap.put(key, packageStr);
	}

	public String getDBType() {
		for (Iterator<Entry<String,String>> iter = dbTypeDriverMap.entrySet().iterator(); iter
				.hasNext();) {
			Entry<String,String> entry = iter.next();
			if (entry.getValue().equals(driverName)) {
				return entry.getKey();
			}
		}
		return null;
	}

	public String getPackage(String key) {
		return packageMap.get(key);
	}

	public void setLoaderPath(String newLoaderPath) {
		this.loaderPath = newLoaderPath;
	}

	public void setOutRootDir(String newOutRootDir) {
		this.outRootDir = newOutRootDir;
	}

	public void setDbSchema(String newDbSchema) {
		this.dbSchema = newDbSchema;
	}

	public void setDbURL(String newDbURL) {
		this.dbURL = newDbURL;
	}

	public void setUser(String newUser) {
		this.user = newUser;
	}

	public void setPwd(String newPwd) {
		this.pwd = newPwd;
	}

	public void setDriverName(String newDriverName) {
		this.driverName = newDriverName;
	}

	public void setDbType(String newDbType) {
		this.dbType = newDbType;
		String driver = dbTypeDriverMap.get(newDbType);
		if (driver != null)
			setDriverName(driver);
	}

	// ---------------------- getters --------------
	public String getLoaderPath() {
		return this.loaderPath;
	}

	public String getOutRootDir() {
		return this.outRootDir;
	}

	public String getDbSchema() {
		return this.dbSchema;
	}

	public String getDbURL() {
		return this.dbURL;
	}

	public String getUser() {
		return this.user;
	}

	public String getPwd() {
		return this.pwd;
	}

	public String getDriverName() {
		return this.driverName;
	}

	public String getDbType() {
		return this.dbType;
	}

}
