package edu.ucsd.fmri.codegen;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DBBeanGenHelper.java,v 1.8 2007/12/11 02:14:22 bozyurt Exp $
 */
public class DBBeanGenHelper extends BeanGenHelper {
	protected String tableName;
	protected String voPackageName;
	protected String expPackageName;
	protected String utilsPackageName;
	protected String interfacePackageName;

	protected Map<String, String> dbColMap = new HashMap<String, String>(17);
	protected Map<String, String> dbColTypeMap = new HashMap<String, String>(17);
	protected Map<String, String> pkColMap = new HashMap<String, String>(7);
	protected Map<String, String> dbSQLTypeMap = new HashMap<String, String>(17);
	protected List<String> dbColumnList = new LinkedList<String>();
	protected Map<String,TypeExceptionInfo> excpMap = null;

	public DBBeanGenHelper(String beanName, String packageName, String tableName) {
		super(beanName, packageName);
		this.tableName = tableName;
	}

	// ---------------------- setters --------------
	public void setTableName(String newTableName) {
		this.tableName = newTableName;
	}

	public void setVoPackageName(String newVoPackageName) {
		this.voPackageName = newVoPackageName;
	}

	public void setExpPackageName(String newExpPackageName) {
		this.expPackageName = newExpPackageName;
	}

	public void setUtilsPackageName(String newUtilsPackageName) {
		this.utilsPackageName = newUtilsPackageName;
	}

	// ---------------------- getters --------------
	public String getTableName() {
		return this.tableName;
	}

	public String getVoPackageName() {
		return this.voPackageName;
	}

	public String getExpPackageName() {
		return this.expPackageName;
	}

	public String getUtilsPackageName() {
		return this.utilsPackageName;
	}

	public void setExcpMap(Map<String, TypeExceptionInfo> map) {
		this.excpMap = map;
	}

	public boolean hasException(String property) {
		if (excpMap == null)
			return false;
		String dbColName = getDbColName(property);
		if (dbColName == null)
			return false;
		String key = getTableName() + "_" + dbColName;
		System.out.println("hasException(" + property + ") = "
				+ excpMap.get(key) != null);
		return (excpMap.get(key) != null);
	}

	public String getExceptionType(String property) {
		String dbColName = getDbColName(property);
		String key = getTableName() + "_" + dbColName;
		TypeExceptionInfo tei = excpMap.get(key);
		System.out.println("getExceptionType() :" + tei.getExcepType());
		return tei.getExcepType();
	}

	public List<String> getDBColumnNameList() {
		if (dbColumnList.isEmpty()) {
			for (Iterator<String> iter = super.propList.iterator(); iter.hasNext();) {
				String property = iter.next();
				String colName = getDbColName(property);
				dbColumnList.add(colName);
			}
		}
		return dbColumnList;
	}

	public boolean hasBooleanProperties() {
		for (Iterator<String> iter = super.propList.iterator(); iter.hasNext();) {
			String property = iter.next();
			if (getType(property).equalsIgnoreCase("boolean"))
				return true;
		}
		return false;
	}

	public boolean hasTimeStampProperties() {
		for (Iterator<String> iter = super.propList.iterator(); iter.hasNext();) {
			String property = iter.next();
			if (getType(property).equalsIgnoreCase("java.sql.Timestamp"))
				return true;
		}
		return false;
	}

	public String getDBColumnNamesAsString() {
		StringBuffer sb = new StringBuffer(128);
		getDBColumnNameList();
		for (Iterator<String> iter = dbColumnList.iterator(); iter.hasNext();) {
			String columnName = iter.next();
			sb.append(columnName);
			if (iter.hasNext())
				sb.append(',');
		}
		return sb.toString();
	}

	public void addColMap(String property, String dbColName) {
		dbColMap.put(property, dbColName);
	}

	public void addColMapType(String property, String colType) {
		dbColTypeMap.put(property, colType);
	}

	public void addSQLTypeType(String property, String sqlType) {
		dbSQLTypeMap.put(property, sqlType);
	}

	public String getDbColName(String property) {
		return dbColMap.get(property);
	}

	public String getDbColType(String property) {
		return dbColTypeMap.get(property);
	}

	public String getSQLType(String property) {
		return dbSQLTypeMap.get(property);
	}

	public void addPkColumn(String property) {
		pkColMap.put(property, property);
	}

	public boolean isPk(String property) {
		return (pkColMap.get(property) == null);
	}

	public String getInterfacePackageName() {
		return interfacePackageName;
	}

	public void setInterfacePackageName(String interfacePackageName) {
		this.interfacePackageName = interfacePackageName;
	}

}
