package edu.ucsd.fmri.codegen;

import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import java.util.Iterator;

import edu.ucsd.fmri.dbutils.DBTable;
import edu.ucsd.fmri.dbutils.SchemaExtractor;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DBExporter.java,v 1.6 2007/12/11 02:14:22 bozyurt Exp $
 */

public class DBExporter {
	protected Connection con;
	private String usr, pwd, dbURL;
	private String driverName;

	public DBExporter(String driverName, String dbURL, String usr, String pwd)
			throws Exception {
		this.driverName = driverName;

		this.usr = usr;
		this.pwd = pwd;
		this.dbURL = dbURL;
		con = connect(dbURL, usr, pwd);
	}

	public static String readCLOB(oracle.sql.CLOB clob) throws SQLException {
		if (clob == null)
			return null;
		StringBuffer buf = new StringBuffer(128);
		Reader r = clob.characterStreamValue();
		int c;
		try {
			while ((c = r.read()) != -1) {
				buf.append((char) c);
			}
		} catch (IOException iox) {
			throw new SQLException(iox.getMessage());
		}
		return buf.toString();
	}

	public void extractTables() throws Exception {
		SchemaExtractor se = null;
		// try {
		se = new SchemaExtractor(this.driverName, dbURL, usr, pwd);
		se.loadDBTables("UCSD_FMRI");
		Iterator<DBTable> iter = se.getTables();
		while (iter.hasNext()) {
			DBTable table = iter.next();
			// skip non BIRN tables
			if (!table.getName().toLowerCase().startsWith("nc_")) {
				continue;
			}
			System.out.println("processing table " + table.getName());
			extractData(table);
		}
	}

	protected Connection connect(String dbURL, String usr, String pwd)
			throws Exception {
		Class.forName("oracle.jdbc.driver.OracleDriver");
		return DriverManager.getConnection(dbURL, usr, pwd);
	}

	protected void extractData(DBTable table) throws SQLException {
		StringBuffer buf = new StringBuffer(512);
		buf.append("select * from ").append(table.getName());
		Statement st = null;
		try {
			st = con.createStatement();
			System.out.println(buf.toString());
			ResultSet rs = st.executeQuery(buf.toString());
			ResultSetMetaData rsmd = rs.getMetaData();
			int colCount = rsmd.getColumnCount();
			while (rs.next()) {
				StringBuffer ibuf = new StringBuffer(512);
				ibuf.append("insert into ").append(table.getName())
						.append(" (");
				for (int i = 1; i <= colCount; ++i) {
					ibuf.append(rsmd.getColumnLabel(i));
					if (i != colCount)
						ibuf.append(',');
				}
				ibuf.append(") values(");

				for (int i = 1; i <= colCount; ++i) {
					Object colValue = rs.getObject(i);
					if (colValue == null) {
						ibuf.append("NULL");
					} else if (colValue instanceof oracle.sql.CLOB) {
						ibuf.append("'").append(
								readCLOB((oracle.sql.CLOB) colValue)).append(
								"'");
					} else {
						switch (rsmd.getColumnType(i)) {
						case Types.CHAR:
						case Types.VARCHAR:
						case Types.DATE:
						case Types.TIMESTAMP:
							ibuf.append("'").append(colValue).append("'");
							break;
						default:
							ibuf.append(colValue);
						}
					}
					if (i != colCount)
						ibuf.append(',');
				}

				ibuf.append(");");
				System.out.println(ibuf.toString());
			}
		} finally {
			if (st != null)
				try {
					st.close();
				} catch (Exception x) {
				}
		}
	}

	public void shutdown() {
		if (con != null)
			try {
				con.close();
			} catch (Exception x) {
			}
	}

	public static void main(String[] args) {
		DBExporter dbe = null;
		try {
			dbe = new DBExporter("oracle.jdbc.driver.OracleDriver",
					"jdbc:oracle:thin:@fmri-gpop:1521:orcl1", "ucsd_fmri",
					"birn");
			dbe.extractTables();
		} catch (Exception ex) {
			ex.printStackTrace();
		} finally {
			if (dbe != null)
				dbe.shutdown();
		}

	}
}
