package edu.ucsd.fmri.codegen;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/**
 * @author I. Burak Ozyurt
 * @version $Id: ExceptionsManager.java,v 1.2 2007/12/11 02:14:22 bozyurt Exp $
 */
public class ExceptionsManager {
	Map<String, Map<String, TypeExceptionInfo>> db2ExcpMap = 
		new HashMap<String, Map<String, TypeExceptionInfo>>(7);

	public ExceptionsManager(URL excpFileURL) throws JDOMException {
		SAXBuilder builder = new SAXBuilder(false);
		Document doc = builder.build(excpFileURL);
		Element root = doc.getRootElement();
		parse(root);

	}

	protected void parse(Element root) {
		List<?> elist = root.getChildren("exceptions");
		for (Iterator<?> iter = elist.iterator(); iter.hasNext();) {
			Element excpGroupElem = (Element) iter.next();
			String db = excpGroupElem.getAttributeValue("db");
			Map<String, TypeExceptionInfo> excepMap = new HashMap<String, TypeExceptionInfo>();
			db2ExcpMap.put(db, excepMap);
			List<?> excList = excpGroupElem.getChildren("exc");
			for (Iterator<?> it = excList.iterator(); it.hasNext();) {
				Element ee = (Element) it.next();
				String tableName = ee.getAttributeValue("table");
				String columnName = ee.getAttributeValue("column");
				String excepType = ee.getAttributeValue("type");
				String key = tableName + "_" + columnName;
				excepMap.put(key, new TypeExceptionInfo(columnName, tableName,
						excepType));
			}
		}
	}

	public boolean hasAnyExceptions(String dbType) {
		return (db2ExcpMap.get(dbType) != null);
	}

	public TypeExceptionInfo getTypeExceptionInfo(String dbType, String key) {
		Map<String, TypeExceptionInfo> excepMap = db2ExcpMap.get(dbType);
		if (excepMap == null) {
			return null;
		}
		return excepMap.get(key);
	}

	public Map<String, TypeExceptionInfo> getExceptionsMap(String dbType) {
		return db2ExcpMap.get(dbType);
	}
}
