package edu.ucsd.fmri.codegen;

import guilib.common.BaseDialog;
import guilib.common.NameComboField;
import guilib.common.NameValueField;
import guilib.common.PasswordField;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ParamsDialog.java,v 1.5 2006/04/19 00:38:18 bozyurt Exp $
 */
public class ParamsDialog extends BaseDialog {
	private static final long serialVersionUID = -4319186156200762240L;
	ConfigurationInfo confInfo;
	NameValueField dbHostField, dbPortField, dbSchemaField, dbNameField;
	NameComboField dbTypeField;
	PasswordField pwdField;

	public ParamsDialog(Frame owner, String title, ConfigurationInfo confInfo) {
		super(owner, title, new String[] { "OK", "Cancel" });
		this.confInfo = confInfo;
		init();
		pack();
	}

	protected DBURLInfo extractDBHost(String dbURL)
	{
		if (dbURL == null || dbURL.trim().length() == 0)
			return null;
		String host = null;
		String dbName = null;
		String dbType = "oracle";
		int port = -1;
		int idx = dbURL.indexOf('@');
		if (idx != -1) {
			dbType = "oracle";
			int endIdx = dbURL.indexOf(':', idx);
			host = dbURL.substring(idx + 1, endIdx);
			idx = endIdx + 1;
			endIdx = dbURL.indexOf(':', idx);
			port = Integer.parseInt(dbURL.substring(idx, endIdx));
			dbName = dbURL.substring(endIdx + 1);
		} else if ((idx = dbURL.indexOf("postgresql")) != -1) {
			dbType = "postgres";
			idx += 13;
			int endIdx = dbURL.indexOf("/", idx);
			host = dbURL.substring(idx, endIdx);
			idx = endIdx + 1;
			dbName = dbURL.substring(idx);
			port = 5432;

		}
		DBURLInfo dbURLInfo = new DBURLInfo(dbType, host, port, dbName);

		return dbURLInfo;
	}

	class DBURLInfo {
		String dbType;
		String host;
		int port;
		String dbName;

		public DBURLInfo(String dbType, String host, int port, String dbName) {
			this.dbType = dbType;
			this.host = host;
			this.port = port;
			this.dbName = dbName;
		}

		public String toJDBCURL()
		{
			StringBuffer buf = new StringBuffer();
			if (dbType.equals("postgres")) {
				buf.append("jdbc:postgresql://").append(host).append('/');
				buf.append(dbName);
			} else {
				buf.append("jdbc:oracle:thin:@").append(host);
				buf.append(':').append(port).append(':').append(dbName);
			}
			return buf.toString();
		}

	}

	protected void init()
	{
		JPanel labelPanel = new JPanel(new GridLayout(6, 1, 3, 3));
		labelPanel.add(new JLabel("Database Type:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Database Host:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Database Port:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Database Name:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Database User/Schema:", JLabel.RIGHT));
		labelPanel.add(new JLabel("Database User Password:", JLabel.RIGHT));

		JPanel panel = new JPanel(new GridLayout(6, 1, 3, 3));

		DBURLInfo dui = extractDBHost(confInfo.getDbURL());

		dbTypeField = new NameComboField(null, new String[] { "oracle",
				"postgres" });
		if (confInfo.getDbType().equals("postgres")) {
			dbTypeField.getComboBox().setSelectedIndex(1);
		}
		panel.add(dbTypeField);
		panel.add(dbHostField = new NameValueField(null, 10));
		if (dui != null)
			dbHostField.setValue(dui.host);
		panel.add(dbPortField = new NameValueField(null, 10));
		if (dui != null)
			dbPortField.setValue("" + dui.port);
		panel.add(dbNameField = new NameValueField(null, 10));
		if (dui != null)
			dbNameField.setValue(dui.dbName);

		panel.add(dbSchemaField = new NameValueField(null, 10));
		dbSchemaField.setValue(confInfo.getDbSchema());

		panel.add(pwdField = new PasswordField(null, 10));

		JPanel paramPanel = new JPanel(new GridLayout(1, 2));
		paramPanel.add(labelPanel);
		paramPanel.add(panel);
		this.setDefaultButton("OK");

		getContentPane().add(paramPanel);
	}

	public ConfigurationInfo getConfInfo()
	{
		return confInfo;
	}

	private boolean hasUserData(String value)
	{
		return (value != null && value.trim().length() > 0);
	}

	public void actionPerformed(ActionEvent e)
	{
		this.returnCode = NONE;
		if (e.getSource() instanceof JButton) {
			JButton button = (JButton) e.getSource();
			if (button.getText().equalsIgnoreCase("ok")) {

				// set the database type
				confInfo.setDbType(dbTypeField.getValue());

				if (hasUserData(dbHostField.getValue())
						&& hasUserData(dbPortField.getValue())
						&& hasUserData(dbNameField.getValue())) {
					DBURLInfo dui = new DBURLInfo(dbTypeField.getValue(),
							dbHostField.getValue(), Integer
									.parseInt(dbPortField.getValue()),
							dbNameField.getValue());

					confInfo.setDbURL(dui.toJDBCURL());
				}

				if (hasUserData(dbSchemaField.getValue())) {
					confInfo
							.setDbSchema(dbSchemaField.getValue().toUpperCase());
					confInfo.setUser(dbSchemaField.getValue().toLowerCase());
				}

				if (pwdField.getValue() != null
						&& pwdField.getValue().length() > 0) {
					confInfo.setPwd(pwdField.getValue());
					this.returnCode = OK_PRESSED;
				} else {
					int rc = JOptionPane
							.showConfirmDialog(
									this,
									"No password is specified! Do you want connect anyway?",
									"No Password", JOptionPane.YES_NO_OPTION);
					if (rc == JOptionPane.YES_OPTION) {
						this.returnCode = OK_PRESSED;
					}
				}
			}
		}
		setVisible(false);

	}

}
