package edu.ucsd.fmri.codegen;

import edu.ucsd.fmri.dbutils.SchemaExtractor;
import guilib.common.BaseDialog;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ProgressDialog.java,v 1.3 2006/04/19 00:38:18 bozyurt Exp $
 */
public class ProgressDialog extends BaseDialog {
	private static final long serialVersionUID = 1591403519590115724L;
	JProgressBar progressBar;
	SchemaExtractionTask task;
	Timer timer;
	Cursor oldCursor;
	Cursor waitCursor = new Cursor(Cursor.WAIT_CURSOR);

	public ProgressDialog(Frame owner, String title, ConfigurationInfo confInfo) {
		super(owner, title, new String[] { "OK" });

		JPanel panel = new JPanel();
		progressBar = new JProgressBar(0, 2);
		progressBar.setValue(0);
		progressBar.setStringPainted(true);
		panel.add(progressBar);
		getContentPane().add(panel);

		pack();
		task = new SchemaExtractionTask(confInfo, getButton("OK"));

		oldCursor = getCursor();
		setCursor(waitCursor);
		timer = new Timer(1000, new ActionListener() {
			public void actionPerformed(ActionEvent e)
			{
				progressBar.setValue(task.getCurrent());
				if (task.done()) {
					setCursor(oldCursor);
					Toolkit.getDefaultToolkit().beep();
					timer.stop();
				}
			}
		});

	}

	public SchemaExtractor getSchemaExtractor()
	{
		return task.getSchemaExtractor();
	}

	public int showDialog()
	{
		this.returnCode = NONE;
		JButton button = this.getButton("OK");

		button.setEnabled(false);
		task.go();
		timer.start();
		setVisible(true);
		if (task.done()) {
			returnCode = OK_PRESSED;

		}
		return returnCode;
	}

	public void actionPerformed(ActionEvent e)
	{
		setVisible(false);
	}

}
