package edu.ucsd.fmri.codegen;

import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

import edu.ucsd.fmri.dbutils.SchemaExtractor;
import guilib.SwingWorker;

public class SchemaExtractionTask {
  private int current = 0;
  private boolean finished = false;
  protected JButton button;

  protected SchemaExtractor schemaExtractor;
  protected ConfigurationInfo ci;

  public SchemaExtractionTask(ConfigurationInfo confInfo, JButton button) {
     ci = confInfo;
     this.button = button;
  }

  public void go() {
    current = 0;
    final SwingWorker worker = new SwingWorker() {
      public Object construct() {
        doIt();
        return this;
      }
    };
    worker.start();
  }

  public SchemaExtractor getSchemaExtractor() { return schemaExtractor; }
  public int getCurrent() { return current; }
  public boolean done() { return finished; }

  protected void doIt() {
    try {
      current = 1;
      String schemaName = ci.getDbSchema();
      if ( ci.getDBType().equals("postgres") ) {
        schemaName = null;
      }

      schemaExtractor = BeanGenerator.createSchemaExtractor( ci.getDriverName(),
          ci.getDbURL(),
          schemaName,
          ci.getUser(),
          ci.getPwd(), true);
       finished = true;
       button.setEnabled(true);
       current = 2;
    }catch (final Exception x) {
      Runnable r = new Runnable() {
        public void run() {
          x.printStackTrace();
          JOptionPane.showMessageDialog(null, x.getMessage(),
                                        "Schema Extraction Error",JOptionPane.ERROR_MESSAGE);
        }

      };
      SwingUtilities.invokeLater(r);
      // x.printStackTrace();
      button.setEnabled(true);
    }

  }

}
