package edu.ucsd.fmri.dbutils;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

/**
 * @author I. Burak Ozyurt
 * @version $Id: DBMetaDataInfo.java,v 1.7 2007/12/11 02:14:22 bozyurt Exp $
 */

public class DBMetaDataInfo {
	private Hashtable<String, DBTable> tables;
	private static DBMetaDataInfo instance;

	private DBMetaDataInfo(Connection con, String schema) throws SQLException {
		tables = new Hashtable<String, DBTable>();
		loadDBSchema(con, schema);
	}

	/**
	 * Gets the Tables attribute of the DBMetaDataInfo object
	 * 
	 * @return The Tables value
	 */
	public Hashtable<String, DBTable> getTables() {
		return this.tables;
	}

	/**
	 * Gets the AllTableNames attribute of the DBMetaDataInfo object
	 * 
	 * @return The AllTableNames value
	 */
	public Collection<String> getAllTableNames() {
		Set<String> tableNames = new TreeSet<String>(tables.keySet());
		return tableNames;
	}

	/**
	 * loads DB schema
	 * 
	 * @param con
	 *            DB connection
	 * @param schema
	 *            DB schema name
	 * @exception SQLException
	 */
	public void loadDBSchema(Connection con, String schema) throws SQLException {
		DatabaseMetaData md = con.getMetaData();
		ResultSet rs = null;
		String[] tableTypes = { "TABLE" };
		rs = md.getTables("", schema, "%", tableTypes);
		while (rs.next()) {
			String tableName = rs.getString(3);
			DBTable table = new DBTable(con, tableName, schema);
			tables.put(tableName, table);
			System.out.println(">> " + tableName);
			// table.showDDL();
		}
	}

	/**
	 * Description of the Method
	 * 
	 * @param con
	 *            Description of Parameter
	 * @exception SQLException
	 *                Description of Exception
	 */
	public static void showDBInfo(Connection con) throws SQLException {
		DatabaseMetaData md = con.getMetaData();
		ResultSet rs = md.getCatalogs();
		System.out.println(" Catalogs\n==============");
		while (rs.next()) {
			System.out.println(rs.getObject(1));
		}
		rs.close();
		rs = md.getSchemas();
		System.out.println(" Schemas\n==============");
		while (rs.next()) {
			System.out.println(rs.getObject(1));
		}
		rs.close();
	}

	/**
	 * Gets the Instance attribute of the DBMetaDataInfo class
	 * 
	 * @param con
	 *            Description of Parameter
	 * @param schema
	 *            Description of Parameter
	 * @return The Instance value
	 * @exception SQLException
	 *                Description of Exception
	 */
	public static synchronized DBMetaDataInfo getInstance(Connection con,
			String schema) throws SQLException {
		if (instance == null) {
			instance = new DBMetaDataInfo(con, schema);
		}
		return instance;
	}

	/**
	 * The main program for the DBMetaDataInfo class
	 * 
	 * @param args
	 *            The command line arguments
	 */
	public static void main(String[] args) {
		Connection con = null;
		try {
			// :TEST:
			String driverName = "oracle.jdbc.driver.OracleDriver";
			String url = "jdbc:oracle:thin:@fmri-gpop:1521:orcl1";
			String user = "bozyurt";
			String password = "bozyurt";

			Class.forName(driverName);

			con = DriverManager.getConnection(url, user, password);

			DBMetaDataInfo mdi = DBMetaDataInfo.getInstance(con, "ORCL1");
			Collection<String> col = mdi.getAllTableNames();
			Iterator<String> it = col.iterator();
			while (it.hasNext()) {
				System.out.println(">> " + it.next());
			}
		} catch (Exception x) {
			x.printStackTrace();
		} finally {
			if (con != null) {
				try {
					con.close();
				} catch (Exception x) {
				}
			}
		}

	}

}
