package edu.ucsd.fmri.dbutils;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * 
 * @author I. Burak Ozyurt
 * @version: $Id: DBTest.java,v 1.4 2007/12/11 02:14:22 bozyurt Exp $
 * 
 */

public class DBTest {
	private List<DBTable> tables;
	private final static String value = "birn";

	public DBTest() {
		tables = new LinkedList<DBTable>();
	}

	public static void main(String[] args) {
		Connection con = null;
		ResultSet rs = null;
		Statement st = null;

		try {
			Class.forName("oracle.jdbc.driver.OracleDriver");
			DBTest dbTool = new DBTest();

			con = DriverManager.getConnection(
					"jdbc:oracle:thin:@fmri-gpop:1521:orcl1", "ucsd_fmri",
					value);
			dbTool.showDBSchema(con, "UCSD_FMRI", true);

			/*
			 * dbTool.prepareDataForMigration("fmri.sql", con, 700, tsMap);
			 * dbTool.prepareCreatePKScript("fmri_pk_create.sql",con);
			 * dbTool.prepareDropScript("fmri_drop.sql",con);
			 * dbTool.prepareTableSizeReport("table_sizes.log",con);
			 */
			/*
			 * st = con.createStatement(); rs = st.executeQuery("SELECT * from
			 * T_USER"); DBTest.showResultSet(rs);
			 */
			/*
			 * while(rs.next()) { System.out.println( rs.getObject(1) ); }
			 */
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (rs != null)
				try {
					rs.close();
				} catch (Exception x) {
				}
			if (st != null)
				try {
					st.close();
				} catch (Exception x) {
				}
			if (con != null)
				try {
					con.close();
				} catch (Exception x) {
				}
		}

	}

	public static void showDBInfo(Connection con) throws SQLException {
		DatabaseMetaData md = con.getMetaData();
		ResultSet rs = md.getCatalogs();
		System.out.println(" Catalogs\n==============");
		while (rs.next()) {
			System.out.println(rs.getObject(1));
		}
		rs.close();
		rs = md.getSchemas();
		System.out.println(" Schemas\n==============");
		while (rs.next()) {
			System.out.println(rs.getObject(1));
		}
		rs.close();
	}

	public void showDBSchema(Connection con, String schema,
			boolean showDBInformation) throws SQLException {
		if (showDBInformation)
			showDBInfo(con);
		DatabaseMetaData md = con.getMetaData();

		ResultSet rs = md.getTableTypes();
		System.out.println(" TableTypes\n==============");
		while (rs.next()) {
			System.out.println(rs.getObject(1));
		}
		rs.close();
		String[] tableTypes = { "TABLE" };
		// String[] tableTypes={"VIEW"}; // do also for views similar to table
		rs = md.getTables("", schema, "%", tableTypes);
		System.out.println("rs=" + rs);

		while (rs.next()) {
			String tableName = rs.getString(3);
			// System.out.println(rs.getObject(1)+","+
			// rs.getObject(2)+","+rs.getObject(3)+","+rs.getObject(4)+","+rs.getObject(5));
			DBTable table = new DBTable(con, tableName, schema);
			tables.add(table);
			table.showDDL();
			// table.extractData(con,5, new BufferedWriter( new
			// OutputStreamWriter(System.out)) );
		}

	}

	public void prepareDataForMigration(String filename, Connection con,
			int maxRows, Hashtable<String,Integer> tableSizeMap) {
		BufferedWriter buf = null;
		try {
			buf = new BufferedWriter(new FileWriter(filename), 512);
			Iterator<DBTable> it = tables.iterator();
			while (it.hasNext()) {
				DBTable table = it.next();
				if (tableSizeMap != null) {
					Integer size =  tableSizeMap.get(table.getName());
					if (size != null)
						table.extractData(con, size.intValue(), buf);
					else
						table.extractData(con, maxRows, buf);
				} else {
					table.extractData(con, maxRows, buf);
				}
				buf.write("---------------\n");
			}
		} catch (IOException iox) {
			iox.printStackTrace();
		} finally {
			if (buf != null)
				try {
					buf.close();
				} catch (Exception x) {
				}
		}
	}

	public void prepareCreatePKScript(String filename, Connection con) {
		BufferedWriter buf = null;
		try {
			buf = new BufferedWriter(new FileWriter(filename), 512);
			Iterator<DBTable> it = tables.iterator();
			while (it.hasNext()) {
				DBTable table = it.next();
				String s = table.getPrimaryKeyDDL();
				if (s != null)
					buf.write(s);
				buf.write("---------------\n");
			}
		} catch (IOException iox) {
			iox.printStackTrace();
		} finally {
			if (buf != null)
				try {
					buf.close();
				} catch (Exception x) {
				}
		}
	}

	public void prepareTableSizeReport(String filename, Connection con) {
		BufferedWriter buf = null;
		try {
			buf = new BufferedWriter(new FileWriter(filename), 512);
			Iterator<DBTable> it = tables.iterator();
			while (it.hasNext()) {
				DBTable table = it.next();
				buf.write(table.getName() + "=" + table.getNoRows(con) + "\n");
			}
		} catch (IOException iox) {
			iox.printStackTrace();
		} finally {
			if (buf != null)
				try {
					buf.close();
				} catch (Exception x) {
				}
		}
	}

	public void prepareDropScript(String filename, Connection con) {
		BufferedWriter buf = null;
		try {
			buf = new BufferedWriter(new FileWriter(filename), 512);
			Iterator<DBTable> it = tables.iterator();
			while (it.hasNext()) {
				DBTable table = it.next();
				buf.write("ALTER TABLE " + table.getName()
						+ " DROP PRIMARY KEY CASCADE;\n");
			}
			it = tables.iterator();
			while (it.hasNext()) {
				DBTable table = it.next();
				buf.write("DROP TABLE " + table.getName()
						+ " CASCADE CONSTRAINTS;\n");
			}
		} catch (IOException iox) {
			iox.printStackTrace();
		} finally {
			if (buf != null)
				try {
					buf.close();
				} catch (Exception x) {
				}
		}
	}

	public static void showResultSet(ResultSet rs) throws SQLException {
		ResultSetMetaData rsmd = rs.getMetaData();
		int colCount = rsmd.getColumnCount();
		for (int i = 0; i < colCount; ++i) {
			System.out.print(rsmd.getColumnName(i + 1));
			int size = rsmd.getColumnName(i + 1).length();
			for (int j = 0; j < (rsmd.getColumnDisplaySize(i + 1) - size); ++j)
				System.out.print(" ");
			System.out.print(" ");
		}
		System.out.println();
		for (int i = 0; i < colCount; ++i) {
			int colWidth = rsmd.getColumnDisplaySize(i + 1);
			for (int j = 0; j < colWidth; ++j)
				System.out.print("-");
			System.out.print(" ");
		}
		System.out.println();
		while (rs.next()) {
			for (int i = 0; i < colCount; ++i) {
				int colWidth = rsmd.getColumnDisplaySize(i + 1);
				Object o = rs.getObject(i + 1);
				int size = 0;
				if (o != null) {
					size = o.toString().length();
					System.out.print(o);
				}
				for (int j = 0; j < (colWidth - size); ++j)
					System.out.print(" ");
				System.out.print(" ");
			}
			System.out.println();
		}
		System.out.println();
	}
}
