package edu.ucsd.fmri.dbutils;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: OracleTypeConversion.java,v 1.4 2008/10/15 21:42:37 bozyurt Exp $
 */

public class OracleTypeConversion implements ITypeConversion {
   protected static OracleTypeConversion instance = null;

   private static Map<String, String> sql2javaMap = new HashMap<String, String>();

   static {
      sql2javaMap.put("varchar2", "String");
      sql2javaMap.put("date", "java.util.Date");
      sql2javaMap.put("clob", "String");
      sql2javaMap.put("float", "Float");
   }

   protected OracleTypeConversion() {}

   public synchronized static OracleTypeConversion getInstance() {
      if (instance == null) {
         instance = new OracleTypeConversion();
      }
      return instance;
   }

   public String getConversionType(DBTable.DBColumn column) {
      if (column.getType().equalsIgnoreCase("number") && column.getWidth() == 1) {
         return "bigdecimal2bool";
      } else if (column.getType().equalsIgnoreCase("char")
            && column.getWidth() == 1) {
         return "string2bool";
      } else if (column.getType().equalsIgnoreCase("clob")) {
         return "clob2string";
      }
      return "";
   }

   public String getSQLType(DBTable.DBColumn column) {
      if (column.getType().equalsIgnoreCase("varchar")
            || column.getType().equalsIgnoreCase("varchar2")) {
         return "Types.VARCHAR";
      } else if (column.getType().equalsIgnoreCase("number")) {
         return "Types.NUMERIC";
      } else if (column.getType().equalsIgnoreCase("clob")) {
         return "Types.CLOB";
      } else if (column.getType().equalsIgnoreCase("float")) {
         return "Types.FLOAT";
      } else if (column.getType().equalsIgnoreCase("char")) {
         return "Types.CHAR";
      } else if (column.getType().equalsIgnoreCase("date")) {
         return "Types.DATE";
      } else if (column.getType().toLowerCase().startsWith("timestamp")) {
         System.out.println("timestamp - " + column.getName() + " width="
               + column.getWidth());
         return "Types.TIMESTAMP";
      } else {
         throw new RuntimeException("Not a supported type:" + column.getType());
      }
   }

   public String toJavaType(DBTable.DBColumn column) {
      String javaType = sql2javaMap.get(column.getType().toLowerCase());
      if (javaType != null)
         return javaType;

      if (column.getType().toLowerCase().startsWith("timestamp")) {
         System.out.println("timestamp - " + column.getName() + " width="
               + column.getWidth());
         return "java.sql.Timestamp";
      }

      if (column.getType().toLowerCase().startsWith("date")) {
         return "java.util.Date";
      }

      if (column.getType().equalsIgnoreCase("number")) {
         if (column.getFracDigit() > 0) {
            return "Double";
         }
         if (column.getWidth() == 1) {
            return "Boolean";
         }
         return "java.math.BigDecimal";

      } else if (column.getType().equalsIgnoreCase("char")) {
         return column.getWidth() == 1 ? "Boolean" : "String";
      } else if (column.getType().equalsIgnoreCase("interval")) {
         return "String";
      } else
         throw new RuntimeException("Not a supported SQL type: "
               + column.getType() + ", " + column.getName());
   }

}
