package edu.ucsd.fmri.dbutils;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author I. Burak Ozyurt
 * @version: $Id: PostgresTypeConversion.java,v 1.5 2005/11/21 20:26:36 bozyurt
 *           Exp $
 *
 */

public class PostgresTypeConversion implements ITypeConversion {
   protected static PostgresTypeConversion instance = null;

   private static Map<String, String> sql2javaMap = new HashMap<String, String>();

   static {
      sql2javaMap.put("varchar", "String");
      sql2javaMap.put("date", "java.util.Date");
      sql2javaMap.put("text", "String");
   }

   protected PostgresTypeConversion() {}

   public synchronized static PostgresTypeConversion getInstance() {
      if (instance == null)
         instance = new PostgresTypeConversion();
      return instance;
   }

   public String getConversionType(DBTable.DBColumn column) {
      if (column.getType().equalsIgnoreCase("number") && column.getWidth() == 1) {
         return "bigdecimal2bool";
      } else if (column.getType().equalsIgnoreCase("char")
            && column.getWidth() == 1) {
         return "string2bool";
      }
      return "";
   }

   public String getSQLType(DBTable.DBColumn column) {
      if (column.getType().equalsIgnoreCase("varchar")) {
         return "Types.VARCHAR";
      } else if (column.getType().equalsIgnoreCase("numeric")) {
         return "Types.NUMERIC";
      } else if (column.getType().equalsIgnoreCase("int8")) {
         return "Types.NUMERIC";
      } else if (column.getType().equalsIgnoreCase("text")) {
         return "Types.VARCHAR";
      } else if (column.getType().equalsIgnoreCase("float")) {
         return "Types.FLOAT";
      } else if (column.getType().equalsIgnoreCase("char")
            || column.getType().equalsIgnoreCase("bpchar")) {
         return "Types.CHAR";
      } else if (column.getType().equalsIgnoreCase("date")) {
         return "Types.DATE";
      } else if (column.getType().toLowerCase().startsWith("timestamp")) {
         // System.out.println("timestamp - "+ column.getName() + " width=" +
         // column.getWidth() );
         return "Types.TIMESTAMP";
      } else if (column.getType().equalsIgnoreCase("float8")) {
         return "Types.DOUBLE";
      } else if (column.getType().equalsIgnoreCase("bool")
            || column.getType().equalsIgnoreCase("boolean")) {
         return "Types.BOOLEAN";
      } else if (column.getType().equalsIgnoreCase("interval")) {
         return "Types.VARCHAR";
      } else {
         throw new RuntimeException("Not a supported type:" + column.getType());
      }
   }

   public String toJavaType(DBTable.DBColumn column) {
      String javaType = sql2javaMap.get(column.getType().toLowerCase());
      if (javaType != null)
         return javaType;

      if (column.getType().toLowerCase().startsWith("timestamp")) {
         System.out.println("timestamp - " + column.getName() + " width="
               + column.getWidth());
         /**
          * TODO a work-around for timestamp and date columns as for all of
          *       them TIMESTAMP is used in Postgres schema.
          */
         if (column.getName().equalsIgnoreCase("time_stamp")) {
            return "java.sql.Timestamp";
         } else {
            return "java.util.Date";
         }
      }

      if (column.getType().toLowerCase().startsWith("date")) {
         return "java.util.Date";
      }

      if (column.getType().equalsIgnoreCase("numeric")) {
         if (column.getFracDigit() > 0) {
            return "Double";
         }
         System.out.println(column.name + "column width =" + column.getWidth()
               + " " + column.getFracDigit());

         if (column.getWidth() == 1) {

            return "Boolean";
         }
         return "java.math.BigDecimal";
      } else if (column.getType().equalsIgnoreCase("int8")) {
         return "java.math.BigDecimal";
      } else if (column.getType().equalsIgnoreCase("bool")
            || column.getType().equalsIgnoreCase("boolean")) {
         return "Boolean";
      } else if (column.getType().equalsIgnoreCase("char")
            || column.getType().equalsIgnoreCase("bpchar")) {
         return column.getWidth() == 1 ? "Boolean" : "String";
      } else if (column.getType().equalsIgnoreCase("float")) {
         return "Float";
      } else if (column.getType().equalsIgnoreCase("float8")) {
         return "Double";
      } else if (column.getType().equalsIgnoreCase("interval")) {
         return "String";
      } else
         throw new RuntimeException("Not a supported SQL type: "
               + column.getType() + ", " + column.getName());
   }

}
