package edu.ucsd.fmri.dbutils;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * @author I. Burak Ozyurt
 * @version $Id: SchemaExtractor.java,v 1.8 2007/12/11 02:14:22 bozyurt Exp $
 */
public class SchemaExtractor {
	private Connection con = null;
	private Map<String, DBTable> tableMap = new HashMap<String, DBTable>();
	private static Map<String, String> sql2javaMap = new HashMap<String, String>();

	static {
		sql2javaMap.put("varchar2", "String");
		sql2javaMap.put("date", "java.util.Date");
		sql2javaMap.put("clob", "String");
		sql2javaMap.put("float", "Double");
	}

	public SchemaExtractor(String driverName, String dbURL, String usr,
			String pwd) throws Exception {
		this.con = connect(driverName, dbURL, usr, pwd);
	}

	protected Connection connect(String driverName, String dbURL, String usr,
			String pwd) throws Exception {
		// "oracle.jdbc.driver.OracleDriver"
		Class.forName(driverName);
		DriverManager.setLoginTimeout(30);
		return DriverManager.getConnection(dbURL, usr, pwd);
	}

	public void shutdown() {
		if (con != null)
			try {
				con.close();
			} catch (Exception x) { /* ignore */
			}
	}

	public void loadDBTables(String schema) throws SQLException {
		loadDBTables(schema, false, false);
	}

	public void loadDBTables(String schema, boolean loadViewsAlso,
			boolean onlyBIRNSchemaTables) throws SQLException {
		DatabaseMetaData md = con.getMetaData();
		ResultSet rs = null;
		String[] tableTypes = { "TABLE" };
		if (loadViewsAlso) {
			tableTypes = new String[2];
			tableTypes[0] = "TABLE";
			tableTypes[1] = "VIEW";
		}
		// String[] tableTypes={"VIEW"}; // do also for views similar to table
		rs = md.getTables("", schema, "%", tableTypes);

		while (rs.next()) {
			String tableName = rs.getString(3);
			if (!onlyBIRNSchemaTables
					|| (onlyBIRNSchemaTables && (tableName.toLowerCase()
							.startsWith("nc_") || tableName.toLowerCase()
							.startsWith("bk_")))) {
				DBTable table = new DBTable(con, tableName, schema);
				tableMap.put(tableName, table);
				table.prepare();
			}
		}
	}

	public DBTable getTable(String tableName) {
		return tableMap.get(tableName);
	}

	public Iterator<DBTable> getTables() {
		return tableMap.values().iterator();
	}

	public static void main(String[] args) {
		SchemaExtractor se = null;
		try {
			se = new SchemaExtractor("oracle.jdbc.driver.OracleDriver",
					"jdbc:oracle:thin:@fmri-gpop:1521:orcl1", "ucsd_fmri", "");
		} catch (Exception x) {
			x.printStackTrace();
		} finally {
			if (se != null)
				se.shutdown();
		}
	}
}
