package edu.ucsd.fmri.dbutils;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: TypeConversionFactory.java,v 1.1 2004/07/16 18:52:44 bozyurt Exp $
 */
public class TypeConversionFactory
{
  protected TypeConversionFactory() {}


  public static ITypeConversion getTypeConversionObject(String dbType) {
     if ( dbType.equalsIgnoreCase("oracle") ) {
         return OracleTypeConversion.getInstance();
     } else if ( dbType.equalsIgnoreCase("postgres") ) {
       return PostgresTypeConversion.getInstance();
     } else {
       throw new RuntimeException("Unsupported Database Server Type:" + dbType);
     }
  }

}