package edu.ucsd.fmri.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */

public class CLIUtils {

	public static String[] prepTable(List<String> items, int numCols) {
		int numRows = items.size() / numCols;
		if ((items.size() % numCols) > 0)
			numRows++;
		String[] rows = new String[numRows];
		Iterator<String> it = items.iterator();
		int idx = 0;
		for (int i = 0; i < numRows; i++) {
			StringBuilder sb = new StringBuilder(80);
			for (int j = 0; j < numCols; j++) {
				if (!it.hasNext())
					break;
				String s = it.next();
				sb.append(idx).append(") ").append(s).append("\t");
				idx++;
			}
			rows[i] = sb.toString().trim();
		}
		return rows;
	}
	
	public static void showTable(String[] rows) {
		System.out.println("------------------------------------");
		for(String row : rows) {
			System.out.println(row);
		}
		System.out.println("------------------------------------");
	}

	public static Set<Integer> selectFromTable(int numItems, String msg)
			throws IOException {
		BufferedReader console = new BufferedReader(new InputStreamReader(
				System.in));
		System.out.println(msg);
		int selection = -1;
		Set<Integer> selections = new LinkedHashSet<Integer>();
		while (true) {
			System.out.print("Please select (0.." + (numItems - 1)
					+ ",all or a comma separated list) >>");
			String ans = console.readLine().trim();
			if (ans.length() > 0) {
				if (ans.equalsIgnoreCase("all")) {
					for (int i = 0; i < numItems; i++) {
						selections.add(i);
					}
					return selections;
				}
				String[] toks = ans.split("\\s*,\\s*");
				for (String tok : toks) {
					selection = Integer.parseInt(tok);
					if (selection >= 0 && selection < numItems) {
						selections.add(selection);
					}
				}
				if (!selections.isEmpty())
					return selections;
			}
		}
	}
}
