package edu.ucsd.fmri.utils;

import java.util.*;
import java.io.*;

public class ConfigurationUtils {
  private ConfigurationUtils() {}

  public static Properties loadProperties(String propsFilename) throws
      IOException
  {
    InputStream is = ConfigurationUtils.class.getClassLoader().
        getResourceAsStream(propsFilename);
    Properties props = new Properties();
    props.load(is);

    return props;
  }

  public static String[] getList(String propertyName, Properties props) {
     String prop = props.getProperty(propertyName);
     if (prop == null || prop.length() == 0) {
       return null;
     }
     StringTokenizer stok = new StringTokenizer(prop,",");
     String[] list = new String[ stok.countTokens() ];
     int idx = 0;
     while (stok.hasMoreTokens()) {
       list[ idx ] =stok.nextToken();
       ++idx;
     }
     return list;
  }

  public static Integer getPropertyInt(String propertyName, String defaultValue, Properties props) {
    String prop = null;
    if (defaultValue == null) {
       prop = props.getProperty(propertyName);
    } else {
      prop = props.getProperty(propertyName, defaultValue);
    }
    if (prop == null) return null;
    try {
       return Integer.valueOf(prop);
    } catch(NumberFormatException nfe) {
      return null;
    }
  }
}