DROP TABLE nc_expEvent CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_expEvent 
--

CREATE TABLE nc_expEvent(
    expManipulationID    NUMBER(38, 0)       NOT NULL,
    tableID              NUMBER(38, 0)       NOT NULL,
    owner                NUMBER(38, 0)       NOT NULL,
    modTime              DATE                NOT NULL,
    modUser              NUMBER(38, 0)       NOT NULL,
    extensionName        VARCHAR2(128)        DEFAULT 'expEvent' NOT NULL,
    condition            VARCHAR2(128),
    eventType            VARCHAR2(18),
    onsetTime            DOUBLE PRECISION,
    duration             DOUBLE PRECISION,
    textValue            VARCHAR2(1024),
    description          CLOB,
    ontologySource       VARCHAR2(128)       NOT NULL,
    conceptID            VARCHAR2(64)        NOT NULL,
    isComposite          NUMBER(1, 0)         DEFAULT 0 NOT NULL,
    uniqueID             NUMBER(38, 0),
    CONSTRAINT nc_expEvent_pk PRIMARY KEY (expManipulationID)
 		USING INDEX
 		(CREATE INDEX nc_expEvent_pidx on nc_expEvent(expManipulationID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_expEvent_sk  UNIQUE (expManipulationID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_expEvent_sidx on nc_expEvent(expManipulationID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_expEvent.expManipulationID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_expEvent.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_expEvent.owner IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_expEvent.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_expEvent.modUser IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_expEvent.extensionName IS 'The extensionName column is used in inheritance hierarchies to name the object (i.e. the table) a tuple is associated with.  This should default to the name of the table.'
;
COMMENT ON COLUMN nc_expEvent.condition IS 'The condition column holds the name of the manipulation (i.e. children of nc_expManipulation - nc_expEvent or nc_expCondition). This name should be descriptive if possible.  The condition name will be used in the generation of any stimulus files and analysis files.'
;
COMMENT ON COLUMN nc_expEvent.onsetTime IS 'The evenTime column is used to store the onset timeof a timed manipulation (i.e. nc_expEvent) relevant to the beginning of an experimental segment (i.e. nc_expSegment) as well as the duration (all entries are in milliseconds - double precision).'
;
COMMENT ON COLUMN nc_expEvent.duration IS 'The evenTime column is used to store the onset timeof a timed manipulation (i.e. nc_expEvent) relevant to the beginning of an experimental segment (i.e. nc_expSegment) as well as the duration (all entries are in milliseconds - double precision).'
;
COMMENT ON COLUMN nc_expEvent.textValue IS 'The textValue column is used to store the textual representations of data from all types.  This provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.'
;
COMMENT ON COLUMN nc_expEvent.description IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
COMMENT ON COLUMN nc_expEvent.ontologySource IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_expEvent.conceptID IS 'The varcharID domain is used to represent alphanumeric identifiers (e.g. the ID of a research subject in a laboratory).'
;
COMMENT ON COLUMN nc_expEvent.isComposite IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN nc_expEvent.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
