DROP TABLE nc_tupleColumns CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_tupleColumns 
--

CREATE TABLE nc_tupleColumns(
    extendedTupleID      NUMBER(38, 0)    NOT NULL,
    columnName           VARCHAR2(128)    NOT NULL,
    columnType           VARCHAR2(64)     NOT NULL,
    tableID              NUMBER(38, 0)    NOT NULL,
    uniqueID             NUMBER(38, 0)    NOT NULL,
    owner                NUMBER(38, 0)    NOT NULL,
    modTime              DATE             NOT NULL,
    modUser              NUMBER(38, 0)    NOT NULL,
    defaultValue         VARCHAR2(255),
    nullable             NUMBER(1, 0)     NOT NULL,
    columnOntology       VARCHAR2(128)    NOT NULL,
    columnConcept        VARCHAR2(64)     NOT NULL,
    measurementSystem    VARCHAR2(128),
    measurementUnit      VARCHAR2(64),
    CONSTRAINT nc_tupleColumns_pk PRIMARY KEY (extendedTupleID, columnName, columnType)
 		USING INDEX
 		(CREATE INDEX nc_tupleColumns_pidx on nc_tupleColumns(extendedTupleID, columnName, columnType)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_tupleColumns_uk_extCol  UNIQUE (extendedTupleID, columnName)
 		USING INDEX
 		(CREATE INDEX nc_tupleColumns_uidx on nc_tupleColumns(extendedTupleID, columnName)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_tupleColumns_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_tupleColumns_sidx on nc_tupleColumns(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_tupleColumns.extendedTupleID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_tupleColumns.columnName IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_tupleColumns.columnType IS 'The type column describes the data type of the object being described by the tuple.'
;
COMMENT ON COLUMN nc_tupleColumns.tableID IS 'The table identifier for all data stored within this table.  In conjunction with a unique ID creates a unique reference to all tuples within the database for tuple level access control.'
;
COMMENT ON COLUMN nc_tupleColumns.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_tupleColumns.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_tupleColumns.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_tupleColumns.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_tupleColumns.defaultValue IS 'The textValue column is used to store the textual representations of data from all types.  This provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.'
;
COMMENT ON COLUMN nc_tupleColumns.nullable IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN nc_tupleColumns.columnOntology IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_tupleColumns.columnConcept IS 'The varcharID domain is used to represent alphanumeric identifiers (e.g. the ID of a research subject in a laboratory).'
;
COMMENT ON COLUMN nc_tupleColumns.measurementSystem IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_tupleColumns.measurementUnit IS 'The name column is used to store the name of the object being described by the tuple. '
;
