drop table nc_databasecolumn ;

create table nc_databasecolumn(
    columnname      varchar(200)    not null,
    tablename       varchar(200)    not null,
    parentcolumn    varchar(200),
    tableid         bigint    not null,
    uniqueid        bigint    not null,
    owner           bigint    not null,
    modtime timestamp not null,
    moduser         bigint    not null,
    description     text,
    constraint nc_databasecolumn_pk primary key (columnname) ,
    constraint nc_databasecolumn_sk  unique (uniqueid, tableid) );

-- comment on column nc_databasecolumn.columnname is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_databasecolumn.tablename is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_databasecolumn.parentcolumn is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_databasecolumn.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_databasecolumn.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_databasecolumn.owner is 'the owner column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the moduser column these two columns specify who owns the data (owner) in a tuple (e.g. the prinicipal investigator of a project who leads the experiment) and who actually entered the data (moduser) in the tuple (e.g. the pi''s graduate student researcher).' ;

-- comment on column nc_databasecolumn.modtime is 'the modtimecolumn is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the moduser column these two columns specify who entered the data (moduser) and when (modtime).  taken together with a core table (nc_tablename) and its backing table (bk_tablename which is used to store the history of changes to a tuple) modtime allows one to fully recreate the history of every tuple stored in a core table.' ;

-- comment on column nc_databasecolumn.moduser is 'the moduser column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the owner column these two columns specify who owns the data (owner) in a tuple (e.g. the prinicipal investigator of a project who leads the experiment) and who actually entered the data (moduser) in the tuple (e.g. the pi''s graduate student researcher).' ;

-- comment on column nc_databasecolumn.description is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

