drop table nc_scorevalidation ;

create table nc_scorevalidation(
    datatable       bigint    not null,
    dataid          bigint    not null,
    uniqueid        bigint    not null,
    tableid         bigint    not null,
    owner           bigint    not null,
    modtime timestamp not null,
    moduser         bigint    not null,
    timestamp       timestamp(6)     not null,
    comments        text,
    validatorid     bigint    not null,
    assessmentid    bigint    not null,
    method          varchar(128)    not null,
    constraint nc_scorevalidation_pk primary key (datatable, dataid) ,
    constraint nc_scorevalidation_sk  unique (uniqueid, tableid) );

-- comment on column nc_scorevalidation.datatable is 'the table identifier for all data stored within this table.  in conjunction with a unique id creates a unique reference to all tuples within the database for tuple level access control.' ;

-- comment on column nc_scorevalidation.dataid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_scorevalidation.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_scorevalidation.tableid is 'the table identifier for all data stored within this table.  in conjunction with a unique id creates a unique reference to all tuples within the database for tuple level access control.' ;

-- comment on column nc_scorevalidation.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_scorevalidation.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_scorevalidation.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_scorevalidation.timestamp is 'the timestamp domain is used to notate the date and time of an occurence (e.g. a subject visit, nc_expcomponent).  the timestamp refers to the beginning (start) time for the object.' ;

-- comment on column nc_scorevalidation.comments is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

-- comment on column nc_scorevalidation.validatorid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_scorevalidation.assessmentid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_scorevalidation.method is 'the name column is used to store the name of the object being described by the tuple. ' ;

