CREATE or REPLACE FUNCTION nc_deriveddata_insert() RETURNS trigger AS '
BEGIN
  insert into nc_researchdata
    ( tableid, uniqueid, owner,modtime, moduser, isbad,                            
    extensionname, datauri, israw, dataontology, dataclass) 
  values(new.tableid,
    new.uniqueid,
    new.owner,
    new.modtime,
    new.moduser, 
    new.isbad,                            
    new.extensionname,                     
    new.datauri,                          
    new.israw,
    new.ontologysource,
    new.conceptid);
    return new;
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_deriveddata_insert  before insert on nc_deriveddata  for each row  EXECUTE PROCEDURE nc_deriveddata_insert();

CREATE OR REPLACE FUNCTION nc_deriveddata_update() RETURNS trigger AS '
BEGIN
  update nc_researchdata
    set owner = new.owner,
        modtime = new.modtime,
        moduser = new.moduser,
        extensionname = new.extensionname,                     
        datauri = new.datauri,                          
        israw = new.israw,
        isbad = new.isbad,
        dataontology = new.ontologysource,                           
        dataclass = new.conceptid
    where
      tableid = new.tableid and uniqueid = new.uniqueid;   
    return new;
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_deriveddata_update  after update on nc_deriveddata  for each row  EXECUTE PROCEDURE nc_deriveddata_update();

CREATE or REPLACE FUNCTION nc_deriveddata_delete() RETURNS trigger AS '
BEGIN
  delete from nc_researchdata
  where
    tableid = old.tableid and uniqueid = old.uniqueid;
  return new;
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_deriveddata_delete   after delete on nc_deriveddata  for each row  EXECUTE PROCEDURE nc_deriveddata_delete();

