DROP TABLE nc_transformationArgument CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_transformationArgument 
--

CREATE TABLE nc_transformationArgument(
    uniqueID       NUMBER(38, 0)    NOT NULL,
    tableID        NUMBER(38, 0)    NOT NULL,
    owner          NUMBER(38, 0)    NOT NULL,
    modTime        DATE             NOT NULL,
    modUser        NUMBER(38, 0)    NOT NULL,
    argName        VARCHAR2(128),
    transformID    NUMBER(38, 0)    NOT NULL,
    optional       NUMBER(1, 0)      DEFAULT 1 NOT NULL,
    CONSTRAINT nc_transformationArgument_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_transformationArgument_pidx on nc_transformationArgument(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_transformationArgument_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_transformationArgument_sidx on nc_transformationArgument(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_transformationArgument.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_transformationArgument.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_transformationArgument.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_transformationArgument.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_transformationArgument.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_transformationArgument.argName IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_transformationArgument.transformID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_transformationArgument.optional IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
