drop table nc_expevent ;

create table nc_expevent(
    expmanipulationid    bigint       not null,
    tableid              bigint       not null,
    owner                bigint       not null,
    modtime timestamp not null,
    moduser              bigint       not null,
    extensionname        varchar(128)        default 'expevent' not null,
    condition            varchar(128),
    eventtype            varchar(18),
    onsettime            double precision,
    duration             double precision,
    textvalue            varchar(1024),
    description          text,
    ontologysource       varchar(128)       not null,
    conceptid            varchar(64)        not null,
    iscomposite          boolean         default false not null,
    uniqueid             bigint,
    constraint nc_expevent_pk primary key (expmanipulationid) ,
    constraint nc_expevent_sk  unique (expmanipulationid, tableid) );

-- comment on column nc_expevent.expmanipulationid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_expevent.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_expevent.owner is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_expevent.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_expevent.moduser is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_expevent.extensionname is 'the extensionname column is used in inheritance hierarchies to name the object (i.e. the table) a tuple is associated with.  this should default to the name of the table.' ;

-- comment on column nc_expevent.condition is 'the condition column holds the name of the manipulation (i.e. children of nc_expmanipulation - nc_expevent or nc_expcondition). this name should be descriptive if possible.  the condition name will be used in the generation of any stimulus files and analysis files.' ;

-- comment on column nc_expevent.onsettime is 'the eventime column is used to store the onset timeof a timed manipulation (i.e. nc_expevent) relevant to the beginning of an experimental segment (i.e. nc_expsegment) as well as the duration (all entries are in milliseconds - double precision).' ;

-- comment on column nc_expevent.duration is 'the eventime column is used to store the onset timeof a timed manipulation (i.e. nc_expevent) relevant to the beginning of an experimental segment (i.e. nc_expsegment) as well as the duration (all entries are in milliseconds - double precision).' ;

-- comment on column nc_expevent.textvalue is 'the textvalue column is used to store the textual representations of data from all types.  this provides an easy way to return the results from queries selecting values of diffferent types without the need for conversion.' ;

-- comment on column nc_expevent.description is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

-- comment on column nc_expevent.ontologysource is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_expevent.conceptid is 'the varcharid domain is used to represent alphanumeric identifiers (e.g. the id of a research subject in a laboratory).' ;

-- comment on column nc_expevent.iscomposite is 'the istrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  the default representation of the domain is that if the value is 1, then the field is true.  the name of the field should be descriptive (e.g. is*condition* true).' ;

-- comment on column nc_expevent.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

