drop table nc_ontologysource ;

create table nc_ontologysource(
    ontologysource    varchar(128)     not null,
    uniqueid          bigint     not null,
    tableid           bigint     not null,
    owner             bigint     not null,
    modtime timestamp not null,
    moduser           bigint     not null,
    sourceuri         varchar(2048),
    description       text,
    constraint nc_ontologysource_pk primary key (ontologysource) ,
    constraint nc_ontologysource_sk  unique (uniqueid, tableid) );

-- comment on column nc_ontologysource.ontologysource is 'the name column is used to store the name of the object being described by the tuple. ' ;

-- comment on column nc_ontologysource.uniqueid is 'the uniqueid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the tableid column these two columns specify a global unique object/tuple identifier within the database.  this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the uniqueid also servers as the principal unique identifier within each core table.' ;

-- comment on column nc_ontologysource.tableid is 'the tableid column is one of the 5 core columns (tableid, uniqueid, owner, modtime, moduser) in the database  taken together with the uniqueid column these two columns specify a global unique object/tuple identifier within the database.   this unique identifying pair is critical for the extended tuple interface, database access controls and time travel. the tableid also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.' ;

-- comment on column nc_ontologysource.owner is 'the database user who who owns the selected tuple.  this could be the user who created the entry or the user who manages/oversees the user who entered the tuple.' ;

-- comment on column nc_ontologysource.modtime is 'the modification time of the current entry (year to fraction(5)).' ;

-- comment on column nc_ontologysource.moduser is 'the user who modified the current tuple entry.  this can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.' ;

-- comment on column nc_ontologysource.sourceuri is 'the uri column references the object being described by the tuple.  for data objects, for example, the uri can reference either an individual object (e.g. file or document) or an entire collection (e.g. directory of dicom images).    a uniform resource identifier (uri) is a compact sequence of characters that identifies an abstract or physical resource.  the standard for uris can be found at: http://www.ietf.org/rfc/rfc3986.txt' ;

-- comment on column nc_ontologysource.description is 'the description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.' ;

