CREATE or replace FUNCTION nc_rawdata_insert() RETURNS trigger AS '
BEGIN
  insert into nc_researchdata
    ( tableid, uniqueid, owner,modtime, moduser,                             
    extensionname, datauri, israw, dataontology, dataclass, isbad) 
  values(new.tableid,
    new.uniqueid,
    new.owner,
    new.modtime,
    new.moduser,                             
    new.extensionname,                     
    new.datauri,                          
    new.israw,
    new.ontologysource,
    new.conceptid,
    new.isbad);
    return new;
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_rawdata_insert before insert on nc_rawdata  for each row  EXECUTE PROCEDURE nc_rawdata_insert();


CREATE or replace FUNCTION nc_rawdata_update() RETURNS trigger AS '
BEGIN
  update nc_researchdata
    set owner = new.owner,
        modtime = new.modtime,
        moduser = new.moduser,
        extensionname = new.extensionname,                     
        datauri = new.datauri,                          
        israw = new.israw,
        dataontology = new.ontologysource,                           
        dataclass = new.conceptid,
        isbad = new.isbad
    where
      tableid = new.tableid and uniqueid = new.uniqueid;   
    return new;
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_rawdata_update  after update on nc_rawdata  for each row  EXECUTE PROCEDURE nc_rawdata_update();

CREATE or replace FUNCTION nc_rawdata_delete() RETURNS trigger AS '
BEGIN
  delete from nc_researchdata
  where
    tableid = old.tableid and uniqueid = old.uniqueid;
  return new;
END;
' LANGUAGE plpgsql;

CREATE TRIGGER nc_rawdata_delete   after delete on nc_rawdata  for each row  EXECUTE PROCEDURE nc_rawdata_delete();

