-- Table: nc_geneticilluminaannotation

-- DROP TABLE nc_geneticilluminaannotation;

CREATE TABLE nc_geneticilluminaannotation
(
  snpname character varying(30) NOT NULL,
  chromosome character varying(2),
  coordinate character varying(30),
  genename character varying(1024),
  locationingene character varying(30),
  locationrelativetogene character varying(30),
  codingstatus character varying(40),
  aminoacid character varying(40),
  CONSTRAINT nc_geneticilluminaannotation_pk PRIMARY KEY (snpname)
)
WITH (OIDS=FALSE);
ALTER TABLE nc_geneticilluminaannotation OWNER TO postgres;


-- Table: nc_geneticannotation

-- DROP TABLE nc_geneticannotation;

CREATE TABLE nc_geneticannotation
(
  annotationsource character varying(64),
  uniqueid bigint NOT NULL,
  snpname character varying(30),
  chromosome character varying(2),
  coordinate bigint,
  genomeversion character varying(15),
  genomerelease character varying,
  cytogeneticband character varying(15),
  genename character varying(40),
  refseq character varying(40),
  genestrand character(1),
  othertranscripts character varying(64),
  locationinrefseq character varying(20),
  ntfromrefseqcdsstart bigint,
  locationingene character varying(30),
  locationrelativetogene character varying(30),
  codingstatus character varying(40),
  aachange_gene character varying(40),
  geneticmapposition double precision,
  mafhapmapceu double precision,
  mafhapmapchbjpt double precision,
  mafhapmapjpt double precision,
  mafhapmapyri double precision,
  phastconservation character varying(40),
  geneticmap double precision,
  locationinrefseqcds character varying(20),
  mhc boolean,
  chrom_xy_homology_reg_marker boolean,
  idels boolean,
  adme boolean,
  CONSTRAINT nc_geneticannotation_pk PRIMARY KEY (uniqueid),
  CONSTRAINT refnc_nc_geneticilluminaannotation_5001 FOREIGN KEY (snpname)
      REFERENCES nc_geneticilluminaannotation (snpname) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (OIDS=FALSE);
ALTER TABLE nc_geneticannotation OWNER TO postgres;


-- Table: nc_geneticchip

-- DROP TABLE nc_geneticchip;

CREATE TABLE nc_geneticchip
(
  chipid bigint NOT NULL,
  chipdescription text,
  chipname character varying(100),
  snpcounts integer,
  chromosomes character varying(255),
  available character varying(5000),
  genomebuild character varying(64),
  CONSTRAINT nc_geneticchip_pk PRIMARY KEY (chipid)
)
WITH (OIDS=FALSE);
ALTER TABLE nc_geneticchip OWNER TO postgres;


-- Table: nc_geneticfamily

-- DROP TABLE nc_geneticfamily;

CREATE TABLE nc_geneticfamily
(
  uniqueid bigint NOT NULL,
  subjectid character varying(64) NOT NULL,
  fatherid character varying(64),
  motherid character varying(64),
  familyid character varying(64) NOT NULL DEFAULT '0'::character varying,
  CONSTRAINT nc_geneticfamily_pk PRIMARY KEY (uniqueid),
  CONSTRAINT refnc_nc_humansubject_5004 FOREIGN KEY (subjectid)
      REFERENCES nc_humansubject (subjectid) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT refnc_nc_humansubject_5005 FOREIGN KEY (fatherid)
      REFERENCES nc_humansubject (subjectid) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT refnc_nc_humansubject_5006 FOREIGN KEY (motherid)
      REFERENCES nc_humansubject (subjectid) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (OIDS=FALSE);
ALTER TABLE nc_geneticfamily OWNER TO postgres;


-- Table: nc_geneticsession

-- DROP TABLE nc_geneticsession;

CREATE TABLE nc_geneticsession
(
  sessionid bigint NOT NULL,
  chipid bigint NOT NULL,
  sessionname character varying(64) NOT NULL,
  expname character varying,
  CONSTRAINT nc_geneticsession_pk PRIMARY KEY (sessionid),
  CONSTRAINT refnc_geneticchip_5000 FOREIGN KEY (chipid)
      REFERENCES nc_geneticchip (chipid) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT nc_geneticsession_sessionname_key UNIQUE (sessionname)
)
WITH (OIDS=FALSE);
ALTER TABLE nc_geneticsession OWNER TO postgres;


-- Table: nc_geneticfinalreporthdr

-- DROP TABLE nc_geneticfinalreporthdr;

CREATE TABLE nc_geneticfinalreporthdr
(
  id integer NOT NULL,
  sessionid integer NOT NULL,
  filename character varying(64),
  uploaddate timestamp(6) without time zone,
  "version" character varying(128),
  processdate character varying(64),
  "content" character varying(64),
  snpcount integer,
  totalsnpcount integer,
  samplecount integer,
  totalsamplecount integer,
  CONSTRAINT nc_geneticfinalreporthdr_pk PRIMARY KEY (id),
  CONSTRAINT refnc_geneticsession_5007 FOREIGN KEY (sessionid)
      REFERENCES nc_geneticsession (sessionid) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (OIDS=FALSE);
ALTER TABLE nc_geneticfinalreporthdr OWNER TO postgres;


-- Table: nc_geneticfinalreport

-- DROP TABLE nc_geneticfinalreport;

CREATE TABLE nc_geneticfinalreport
(
  reportid integer NOT NULL,
  subjectid character varying(64) NOT NULL,
  snpname character varying(50) NOT NULL,
  chr character varying(10),
  "position" character varying(20),
  allele1 character(1),
  allele2 character(1),
  gcscore double precision,
  ilmnstrand character varying(10),
  customstrand character varying(10),
  gtscore double precision,
  r double precision,
  x double precision,
  y double precision,
  xraw integer,
  yraw integer,
  logr double precision,
  ballelefreq double precision,
  rowid serial NOT NULL,
  CONSTRAINT nc_geneticfinalreport_py PRIMARY KEY (reportid, subjectid, snpname),
  CONSTRAINT refnc_geneticfinalreporthdr FOREIGN KEY (reportid)
      REFERENCES nc_geneticfinalreporthdr (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT refnc_nc_geneticilluminaannotation_5002 FOREIGN KEY (snpname)
      REFERENCES nc_geneticilluminaannotation (snpname) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT refnc_nc_humansubject_5003 FOREIGN KEY (subjectid)
      REFERENCES nc_humansubject (subjectid) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (OIDS=FALSE);
ALTER TABLE nc_geneticfinalreport OWNER TO postgres;

-- Table: nc_geneticfinalreport2

-- DROP TABLE nc_geneticfinalreport2;

CREATE TABLE nc_geneticfinalreport2
(
  sampleid character varying(64) NOT NULL,
  snpname character varying(50) NOT NULL,
  ilmnstrand character varying(10),
  customstrand character varying(10),
  chr character varying(10),
  allele1 character(1),
  allele2 character(1),
  "position" character varying(20),
  gcscore character varying(15),
  r character varying(15),
  x character varying(15),
  y character varying(15),
  xraw character varying(15),
  yraw character varying(15),
  logr character varying(15),
  ballelefreq character varying(15)
)
WITH (OIDS=FALSE);
ALTER TABLE nc_geneticfinalreport2 OWNER TO postgres;

-- Table: nc_geneticfinalreport3

-- DROP TABLE nc_geneticfinalreport3;

CREATE TABLE nc_geneticfinalreport3
(
  sampleindex character varying(64) NOT NULL,
  sampleid character varying(64) NOT NULL,
  gcscore character varying(15),
  snpindex character varying(64),
  snpname character varying(50) NOT NULL,
  allele1 character(1),
  allele2 character(1),
  allele1forward character(1),
  allele2forward character(1),
  allele1ab character(1),
  allele2ab character(1),
  chr character varying(10),
  "position" character varying(20),
  gtscore character varying(15),
  clustersep character varying(64),
  snp character varying(64),
  theta character varying(64),
  r character varying(15),
  x character varying(15),
  y character varying(15),
  xraw character varying(15),
  yraw character varying(15),
  ballelefreq character varying(15),
  logr character varying(15)
)
WITH (OIDS=FALSE);
ALTER TABLE nc_geneticfinalreport3 OWNER TO postgres;


-- Table: nc_geneticgenelist

-- DROP TABLE nc_geneticgenelist;

CREATE TABLE nc_geneticgenelist
(
  uniqueid bigint NOT NULL,
  genelistname character varying(50) NOT NULL,
  genelist character varying(250),
  sessionid bigint,
  CONSTRAINT nc_geneticgenelist_pkey PRIMARY KEY (uniqueid),
  CONSTRAINT nc_geneticgenelist_genelistname_key UNIQUE (genelistname)
)
WITH (OIDS=FALSE);
ALTER TABLE nc_geneticgenelist OWNER TO postgres;

-- Table: nc_geneticids

-- DROP TABLE nc_geneticids;

CREATE TABLE nc_geneticids
(
  reportid integer NOT NULL,
  sampleid character varying(64) NOT NULL,
  subjectid character varying(64),
  localid character varying(64),
  comments text
)
WITH (OIDS=FALSE);
ALTER TABLE nc_geneticids OWNER TO postgres;


-- Table: nc_geneticilluminaannotation2

-- DROP TABLE nc_geneticilluminaannotation2;

CREATE TABLE nc_geneticilluminaannotation2
(
  snpname character varying(30) NOT NULL,
  chromosome character varying(2),
  coordinate character varying(30),
  genome_build character varying(30),
  gene_symbol character varying(30),
  genename character varying(1024),
  accession character varying(30),
  locationingene character varying(30),
  locationrelativetogene character varying(30),
  codingstatus character varying(40),
  aminoacid character varying(40),
  id_with_mouse character varying(30),
  phast_conservation character varying(30),
  CONSTRAINT nc_geneticilluminaannotation2_pk PRIMARY KEY (snpname)
)
WITH (OIDS=FALSE);
ALTER TABLE nc_geneticilluminaannotation2 OWNER TO postgres;


-- Table: nc_geneticsnplist

-- DROP TABLE nc_geneticsnplist;

CREATE TABLE nc_geneticsnplist
(
  uniqueid bigint NOT NULL,
  snplistname character varying(50) NOT NULL,
  snplist character varying(250),
  sessionid bigint,
  CONSTRAINT uniqueid PRIMARY KEY (uniqueid),
  CONSTRAINT nc_geneticsnplist_snplistname_key UNIQUE (snplistname)
)
WITH (OIDS=FALSE);
ALTER TABLE nc_geneticsnplist OWNER TO postgres;

-- Index: fki_

-- DROP INDEX fki_;

CREATE INDEX fki_
  ON nc_geneticsnplist
  USING btree
  (sessionid);


