DROP TABLE nc_compiler CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_compiler 
--

CREATE TABLE nc_compiler(
    uniqueID           NUMBER(38, 0)    NOT NULL,
    tableID            NUMBER(38, 0)    NOT NULL,
    owner              NUMBER(38, 0)    NOT NULL,
    modTime            DATE             NOT NULL,
    modUser            NUMBER(38, 0)    NOT NULL,
    compiler           VARCHAR2(128),
    compilerVersion    VARCHAR2(64),
    description        CLOB,
    CONSTRAINT nc_compiler_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_compiler_pidx on nc_compiler(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_compiler_sk  UNIQUE (uniqueID, tableID)
 		USING INDEX
 		(CREATE INDEX nc_compiler_sidx on nc_compiler(uniqueID, tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_compiler.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_compiler.tableID IS 'The tableID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the uniqueID column these two columns specify a global unique object/tuple identifier within the database.   This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The tableID also servers as a supplementary identifier that allows each tuple''s containing table to be easily denoted.'
;
COMMENT ON COLUMN nc_compiler.owner IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_compiler.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_compiler.modUser IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_compiler.compiler IS 'The name column is used to store the name of the object being described by the tuple. '
;
COMMENT ON COLUMN nc_compiler.compilerVersion IS 'The varcharID domain is used to represent alphanumeric identifiers (e.g. the ID of a research subject in a laboratory).'
;
COMMENT ON COLUMN nc_compiler.description IS 'The description column is an open field for any comments or descriptions for a specific entry (i.e. tuple) in the database.'
;
