DROP TABLE nc_rangeValidator CASCADE CONSTRAINTS
;
-- 
-- TABLE: nc_rangeValidator 
--

CREATE TABLE nc_rangeValidator(
    uniqueID         NUMBER(38, 0)    NOT NULL,
    tableID          NUMBER(38, 0)    NOT NULL,
    owner            NUMBER(38, 0)    NOT NULL,
    modTime          DATE             NOT NULL,
    modUser          NUMBER(38, 0)    NOT NULL,
    lowLimit         NUMBER           NOT NULL,
    upperLimit       NUMBER           NOT NULL,
    incLowLimit      CHAR(1)           DEFAULT 'Y' NOT NULL,
    incUpperLimit    CHAR(1)           DEFAULT 'Y' NOT NULL,
    CONSTRAINT check_inc_low_limit CHECK (incLowLimit IN ('N','Y')),
    CONSTRAINT check_inc_upp_limit CHECK (incUpperLimit IN ('N','Y')),
    CONSTRAINT nc_rangeValidator_pk PRIMARY KEY (uniqueID)
 		USING INDEX
 		(CREATE INDEX nc_rangeValidator_pidx on nc_rangeValidator(uniqueID)
		TABLESPACE &&tablespace_index),
    CONSTRAINT nc_rangeValidator_sk  UNIQUE (tableID)
 		USING INDEX
 		(CREATE INDEX nc_rangeValidator_sidx on nc_rangeValidator(tableID)
		TABLESPACE &&tablespace_index)
)
TABLESPACE &&tablespace_data
;



COMMENT ON COLUMN nc_rangeValidator.uniqueID IS 'The uniqueID column is one of the 5 core columns (tableID, uniqueID, owner, modTime, modUser) in the database  Taken together with the tableID column these two columns specify a global unique object/tuple identifier within the database.  This unique identifying pair is critical for the extended tuple interface, database access controls and time travel. The uniqueID also servers as the principal unique identifier within each core table.'
;
COMMENT ON COLUMN nc_rangeValidator.tableID IS 'The table identifier for all data stored within this table.  In conjunction with a unique ID creates a unique reference to all tuples within the database for tuple level access control.'
;
COMMENT ON COLUMN nc_rangeValidator.owner IS 'The database user who who owns the selected tuple.  This could be the user who created the entry or the user who manages/oversees the user who entered the tuple.'
;
COMMENT ON COLUMN nc_rangeValidator.modTime IS 'The modification time of the current entry (YEAR to FRACTION(5)).'
;
COMMENT ON COLUMN nc_rangeValidator.modUser IS 'The user who modified the current tuple entry.  This can be different than the owner; if the user is entering data for the owner or if a user edited a tuple.'
;
COMMENT ON COLUMN nc_rangeValidator.incLowLimit IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
COMMENT ON COLUMN nc_rangeValidator.incUpperLimit IS 'The isTrue domain is used to store boolean (i.e yes/no, true/false, or 1/0) data.  The default representation of the domain is that if the value is 1, then the field is true.  The name of the field should be descriptive (e.g. is*Condition* true).'
;
